<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Exit if accessed directly

class Widget_Init {

	public $prefix;
	public $category;
	public $widgets;

	public function __construct() {
		$this->init();
		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_style' ) );
		add_action( 'elementor/elements/categories_registered', array( $this, 'widget_categoty' ) );
		add_action( 'elementor/widgets/register', array( $this, 'register_widgets' ) );
	}

	private function init() {
		$this->prefix   = 'onelisting';
		$this->category = __( 'Theme Elements', 'onelisting' );

		// Widgets -- dirname=>classname
		$widgets1 = array(
			'title'        => 'Title',
			'cta'          => 'CTA',
			'contact-info' => 'Contact_Info',
			'post'         => 'Post',
			'counter'      => 'Counter',
			'testimonial'  => 'Testimonial',
		);

		$widgets2 = array();

		if ( class_exists( 'Directorist_Base' ) ) {
			$widgets2 = array(
				'listing-categories'  => 'Listing_Categories',
				'all-listings'        => 'All_Listing',
				'single-location-box' => 'Single_Location_Box',
				'search-listing'      => 'Search_Listing',
			);
		}

		$this->widgets = array_merge( $widgets1, $widgets2 );
	}

	public function editor_style() {
		$img = get_stylesheet_directory_uri() . '/elementor-support/icon.png';
		wp_add_inline_style( 'elementor-editor', '.elementor-control-type-select2 .elementor-control-input-wrapper {min-width: 130px;}.elementor-element .icon .wpwaxtheme-el-custom{content: url(' . $img . ');width: 22px;}' );
	}

	public function widget_categoty( $class ) {
		$id         = $this->prefix . '-widgets';
		$properties = array(
			'title' => $this->category,
		);

		Plugin::$instance->elements_manager->add_category( $id, $properties );
	}

	public function register_widgets() {
		require_once __DIR__ . '/base.php';

		foreach ( $this->widgets as $dirname => $class ) {
			$template_name = '/elementor-support/' . $dirname . '/class.php';

			if ( file_exists( STYLESHEETPATH . $template_name ) ) {
				$file = STYLESHEETPATH . $template_name;
			} elseif ( file_exists( TEMPLATEPATH . $template_name ) ) {
				$file = TEMPLATEPATH . $template_name;
			} else {
				$file = __DIR__ . '/' . $dirname . '/class.php';
			}

			// Include Widget files
			require_once $file;

			// Register widget
			$classname = __NAMESPACE__ . '\\' . $class;
			Plugin::instance()->widgets_manager->register( new $classname );
		}
	}
}

new Widget_Init();