<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Directorist\Helper;
use Elementor\Controls_Manager;
use wpWax\OneListing\Directorist_Support;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Listing_Categories extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = esc_html__( 'Listing Categories', 'onelisting' );
		$this->wpwax_base = 'wpwaxtheme-all-categories';
		parent::__construct( $data, $args );

	}

	private function wpwax_listing_categories() {
		$result     = array();
		$categories = get_terms( ATBDP_CATEGORY );
		foreach ( $categories as $category ) {
			$result[$category->slug] = $category->name;
		}

		return $result;
	}

	private function wpwax_listing_types() {
		$listing_types = array();
		$all_types     = get_terms( array( 'taxonomy' => ATBDP_TYPE, 'hide_empty' => false ) );

		foreach ( $all_types as $type ) {
			$listing_types[$type->slug] = $type->name;
		}

		return $listing_types;
	}

	public function wpwax_fields() {
		$fields = array(
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'onelisting' )
			),
			array(
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'default_type',
				'label'     => esc_html__( 'Default Directory Types', 'onelisting' ),
				'options'   => $this->wpwax_listing_types(),
				'condition' => Helper::multi_directory_enabled() ? '' : array( 'nocondition' => true )
			),
			array(
				'type'      => Controls_Manager::SELECT,
				'id'        => 'columns',
				'label'     => esc_html__( 'Number of columns', 'onelisting' ),
				'options'   => array(
					'2' => esc_html__( '2', 'onelisting' ),
					'3' => esc_html__( '3', 'onelisting' ),
					'4' => esc_html__( '4', 'onelisting' ),
					'6' => esc_html__( '6', 'onelisting' )
				),
				'default'   => '3'
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'order_by',
				'label'   => __( 'Order by', 'onelisting' ),
				'options' => array(
					'id'    => __( 'ID', 'onelisting' ),
					'count' => __( 'Count', 'onelisting' ),
					'name'  => __( 'Name', 'onelisting' ),
					'slug'  => __( 'Slug', 'onelisting' )
				),
				'default' => 'slug'
			),
			array(
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'slug',
				'label'     => esc_html__( 'Specify Categories', 'onelisting' ),
				'multiple'  => true,
				'options'   => $this->wpwax_listing_categories(),
				'condition' => array( 'order_by' => array( 'slug' ) )
			),
			array(
				'type'    => Controls_Manager::SELECT,
				'id'      => 'order_list',
				'label'   => esc_html__( 'Categories Order', 'onelisting' ),
				'options' => array(
					'asc'  => esc_html__( ' ASC', 'onelisting' ),
					'desc' => esc_html__( ' DESC', 'onelisting' )
				),
				'default' => 'desc'
			),
			array(
				'type'      => Controls_Manager::SWITCHER,
				'id'        => 'hide_subcategories',
				'label'     => esc_html__( 'Hide Subcategories?', 'onelisting' ),
				'default'   => 'no'
			),
			array(
				'mode' => 'section_end'
			),
		);

		return $fields;
	}

	public function directorist_category_subterms_html( $html ) {
		return;
	}


	protected function render() {

		$data = $this->get_settings_for_display();

		$atts = array(
			'view'    => '',
			'columns' => $data['columns'],
			'orderby' => $data['order_by'],
			'order'   => $data['order_list'],
			'slug'    => $data['slug'] ? implode( ',', $data['slug'] ) : '',
		);

		if ( 'yes' === $data['hide_subcategories'] ) {
			add_filter( 'directorist_category_subterms_html', array( $this, 'directorist_category_subterms_html' ) );
		}

		if ( Helper::multi_directory_enabled() ) {

			$atts['directory_type'] = '';

			if ( $data['default_type'] ) {
				$atts['default_directory_type'] = $data['default_type'];
			}

		}

		$data = Directorist_Support::get_taxonomy_data( $atts );

		return $this->wpwax_template( 'view', $data );
	}
}