<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\OneListing\Directorist_Support;

if ( ! isset( $data['location_obj'] ) || empty( $data['location_obj'] ) ) {
	return;
}

$location      = $data['location_obj'];
$permalink     = get_term_link( $location->slug, $location->taxonomy );

$image_id      = get_term_meta( $location->term_id, 'image', true );
$image_url     = isset( $data['image']['url'] ) &&  ! empty( $data['image']['url'] ) ? $data['image']['url'] : atbdp_get_image_source( $image_id,  'wpwaxtheme-260x300' );
$loc_class     = $image_url ? '' : ' atbd_location_grid-default';
$listing_count = atbdp_listings_count_by_location( $location->term_id );
$count_html	   = '';

if ( $listing_count ) {
	$tax               = ATBDP_LOCATION;
	$expired_listings  = atbdp_get_expired_listings( $tax, $location->term_id );
	$number_of_expired = $expired_listings->post_count;
	$number_of_expired = ! empty( $number_of_expired ) ? $number_of_expired : '0';
	$total             = ( $listing_count ) ? ( $listing_count - $number_of_expired ) : $listing_count;
	$count_html		   = sprintf( '<p>%s %s</p>', $total, ( ( $total > 1 ) || ( $total == 0 ) ) ? esc_html__( 'listings', 'onelisting' ) : esc_html__( 'listing', 'onelisting' ) );	
}
?>

<div class="atbd_location_grid_wrap atbdp-no-margin">

	<a class="atbd_location_grid<?php echo esc_attr( $loc_class ); ?>" href="<?php echo esc_url( $permalink ); ?>">

		<figure>

			<?php if ( $image_url ): ?>

				<img src="<?php echo esc_url( $image_url ); ?>" title="<?php echo esc_attr( $location->name ); ?>" alt="<?php echo esc_attr( $location->name ); ?>">

			<?php endif;?>

			<figcaption>

				<div class="directorist-location-content">

					<?php if ( Directorist_Support::has_parent_name( $location ) ) :?>

						<p class="directorist-location-parent"><?php echo Directorist_Support::has_parent_name( $location ); ?></p>

					<?php endif; ?>

						<h3 class="directorist-location"><?php echo esc_html( $location->name ); ?><?php directorist_icon( 'las la-arrow-right' ); ?></h3>

					<p class="directorist-listing-count">

						<?php printf( _nx( '%s listing', '%s listings', intval( atbdp_listings_count_by_location( $location->term_id ) ), '', 'onelisting' ), wp_kses_post( atbdp_listings_count_by_location( $location->term_id ) ) );?>

					</p>				
				
				</div>

			</figcaption>

		</figure>

	</a>

</div>