<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Testimonial extends Custom_Widget_Base {

	public function __construct( $data = array(), $args = null ) {
		$this->wpwax_name = __( 'Testimonial Carousel', 'onelisting' );
		$this->wpwax_base = 'wpwaxtheme-testimonial-carousel';
		parent::__construct( $data, $args );
	}

	private function get_repeater() {
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', array(
				'label'       => esc_html__( 'Name', 'onelisting' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'John Doe', 'onelisting' ),
			)
		);

		$repeater->add_control(
			'location', array(
				'label'      => esc_html__( 'Designation', 'onelisting' ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'Manager', 'onelisting' ),
			)
		);

		$repeater->add_control(
			'content', array(
				'label'      => esc_html__( 'Content', 'onelisting' ),
				'type'       => \Elementor\Controls_Manager::WYSIWYG,
				'default'    => esc_html__( 'Lorem Ipsum has been standard daand scrambled. Rimply dummy text of the printing and typesetting industry', 'onelisting' ),
			)
		);

		$repeater->add_control(
			'image', array(
				'label' => esc_html__( 'Thumbnail', 'onelisting' ),
				'type'  => Controls_Manager::MEDIA,
			)
		);

		return $repeater;
	}

	public function wpwax_fields() {
		$fields = array(

			// General Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_general',
				'label' => esc_html__( 'General', 'onelisting' ),
			),
			array(
				'type'   => Controls_Manager::REPEATER,
				'id'     => 'items',
				'label'  => esc_html__( 'Add as many items as you want', 'onelisting' ),
				'fields' => $this->get_repeater()->get_controls(),
			),
			array(
				'mode' => 'section_end',
			),

			// Slider Options Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_slider',
				'label' => __( 'Slider Options', 'onelisting' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => __( 'Autoplay', 'onelisting' ),
				'label_on'    => __( 'On', 'onelisting' ),
				'label_off'   => __( 'Off', 'onelisting' ),
				'default'     => 'yes',
				'description' => __( 'Enable or disable autoplay. Default: On', 'onelisting' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_stop_on_hover',
				'label'       => __( 'Stop on Hover', 'onelisting' ),
				'label_on'    => __( 'On', 'onelisting' ),
				'label_off'   => __( 'Off', 'onelisting' ),
				'default'     => 'yes',
				'description' => __( 'Stop autoplay on mouse hover. Default: On', 'onelisting' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SELECT2,
				'id'          => 'slider_interval',
				'label'       => __( 'Autoplay Interval', 'onelisting' ),
				'options'     => array(
					'5000' => __( '5 Seconds', 'onelisting' ),
					'4000' => __( '4 Seconds', 'onelisting' ),
					'3000' => __( '3 Seconds', 'onelisting' ),
					'2000' => __( '2 Seconds', 'onelisting' ),
					'1000' => __( '1 Second', 'onelisting' ),
				),
				'default'     => '5000',
				'description' => __( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'onelisting' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::NUMBER,
				'id'          => 'slider_autoplay_speed',
				'label'       => __( 'Autoplay Slide Speed', 'onelisting' ),
				'default'     => 200,
				'description' => __( 'Slide speed in milliseconds. Default: 200', 'onelisting' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => __( 'Loop', 'onelisting' ),
				'label_on'    => __( 'On', 'onelisting' ),
				'label_off'   => __( 'Off', 'onelisting' ),
				'default'     => 'yes',
				'description' => __( 'Loop to first item. Default: On', 'onelisting' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Color Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_style',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'Color', 'onelisting' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'name_color',
				'label'     => __( 'Name', 'onelisting' ),
				'selectors' => array( '.theme-testimonial-single__author-info .theme-testimonial-blockquote .theme-testimonial-blockquote__footer cite span.cite-title' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'designation_color',
				'label'     => __( 'Designation', 'onelisting' ),
				'selectors' => array( '.theme-testimonial-single__author-info .theme-testimonial-blockquote .theme-testimonial-blockquote__footer cite span.cite-subtitle' => 'color: {{VALUE}}' ),
			),
			array(
				'type'      => Controls_Manager::COLOR,
				'id'        => 'content_color',
				'label'     => __( 'Content', 'onelisting' ),
				'selectors' => array( 
					'.theme-testimonial-single__author-comment' => 'color: {{VALUE}}',
					'.theme-testimonial-single__author-comment p' => 'color: {{VALUE}}',
				 ),
			),
			array(
				'mode' => 'section_end',
			),

			// Typo Section
			array(
				'mode'  => 'section_start',
				'id'    => 'sec_typo',
				'tab'   => Controls_Manager::TAB_STYLE,
				'label' => __( 'Typography', 'onelisting' ),
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'name_typo',
				'label'    => __( 'Name', 'onelisting' ),
				'selector' => '.theme-testimonial-single__author-info .theme-testimonial-blockquote .theme-testimonial-blockquote__footer cite span.cite-title',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'location_typo',
				'label'    => __( 'Designation', 'onelisting' ),
				'selector' => '.theme-testimonial-single__author-info .theme-testimonial-blockquote .theme-testimonial-blockquote__footer cite span.cite-subtitle',
			),
			array(
				'mode'     => 'group',
				'type'     => \Elementor\Group_Control_Typography::get_type(),
				'id'       => 'content_typo',
				'label'    => __( 'Content', 'onelisting' ),
				'selector' => '.theme-testimonial-single__author-comment, .theme-testimonial-single__author-comment p',
			),
			array(
				'mode' => 'section_end',
			),
		);

		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$tiny_data = array(
			'nav'                  => true,
			'navPosition'          => 'bottom',
			'items'                => 1,
			'slideBy'              => 'page',
			'autoplayButtonOutput' => false,
			'mouseDrag'            => true,
			'lazyload'             => true,
			'controls'             => true,
			'controlsText'         => function_exists( 'directorist_icon' ) ? array( directorist_icon( 'fas fa-angle-left', false ), directorist_icon( 'fas fa-angle-right', false ) ) : '',
			'autoplay'             => false,
			'autoplayTimeout'      => $data['slider_interval'],
			'autoplaySpeed'        => $data['slider_autoplay_speed'],
			'autoplayHoverPause'   => $data['slider_stop_on_hover'] == 'yes' ? true : false,
			'loop'                 => $data['slider_loop'] == 'yes' ? true : false,
			'margin'               => 20,
			'responsive'           => array(
				'0' => array( 'items' => 1 ),
			),
		);

		$data['tiny_data'] = json_encode( $tiny_data );

		$template = 'view';

		return $this->wpwax_template( $template, $data );
	}
}