<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\Theme\Elementor;
?>
<div class="theme-testimonial-slider">

	<div class="theme-swiper theme-carousel" data-sw-items="1" data-sw-margin="24" data-sw-loop="true" data-sw-perslide="1" data-sw-speed="1000" data-sw-autoplay="{}" data-sw-responsive='{
		"0": {"slidesPerView": "1"},
		"768": {"slidesPerView": "1"}
	}'>
		<div class="swiper-wrapper">
			<?php foreach ( $data['items'] as $item ): ?>

				<div class="swiper-slide item">

					<div class="theme-testimonial-single">

						<?php if ( $item['image'] ): ?>

							<div class="theme-testimonial-single__author-thumb">

								<?php echo wp_get_attachment_image( $item['image']['id'], 'thumbnail' ); ?>

							</div>

						<?php endif;?>

						<div class="theme-testimonial-single__author">

							<div class="theme-testimonial-single__author-comment"><?php echo wp_kses_post( $item['content'] ); ?></div>

							<div class="theme-testimonial-single__author-info">

								<blockquote class="theme-testimonial-blockquote blockquote">

									<footer class="theme-testimonial-blockquote__footer blockquote-footer">

										<cite title="source Title">

											<span class="cite-title"><?php echo esc_html( $item['name'] ); ?></span>

											<?php if ( $item['location'] ): ?>

												<span class="cite-subtitle"><?php echo esc_html( $item['location'] ); ?></span>

											<?php endif;?>

										</cite>

									</footer>

								</blockquote>

							</div>

						</div>

					</div>

				</div>

			<?php endforeach;?>
		</div>

		<div class="theme-swiper-pagination"></div>	
		

		<div class="theme-swiper-navigation">

			<div class="theme-swiper-button-nav theme-swiper-button-prev"><?php directorist_icon( 'fas fa-angle-left' ); ?></div>

			<div class="theme-swiper-button-nav theme-swiper-button-next"><?php directorist_icon( 'fas fa-angle-right' ); ?></div>

		</div>

	</div>

</div>