<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

if ( ! class_exists( 'CSF' ) ) {
	return;
}

use \CSF;

$prefix = Constants::$theme_options . '_layout_settings_page';

// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'     => 'Layout Settings',
	'post_type' => 'page',
	'context'   => 'side',
) );

// Create a section
CSF::createSection(
	$prefix,
	array(
		'fields' => array(
			array(
				'id'      => $prefix . '_layout',
				'type'    => 'select',
				'title'   => esc_html__( 'Layout', 'onelisting' ),
				'options' => array(
					'default'       => esc_html__( 'Default', 'onelisting' ),
					'left-sidebar'  => esc_html__( 'Left Sidebar', 'onelisting' ),
					'full-width'    => esc_html__( 'No Sidebar', 'onelisting' ),
					'right-sidebar' => esc_html__( 'Right Sidebar', 'onelisting' ),
				),
				'default' => 'default',
			),
			array(
				'id'      => $prefix . '_banner',
				'type'    => 'select',
				'title'   => esc_html__( 'Banner', 'onelisting' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'onelisting' ),
					'on'      => esc_html__( 'Enabled', 'onelisting' ),
					'off'     => esc_html__( 'Disabled', 'onelisting' ),
				),
				'default' => 'default',
			),
			array(
				'id'         => $prefix . '_breadcrumb',
				'type'       => 'select',
				'title'      => esc_html__( 'Breadcrumb', 'onelisting' ),
				'options'    => array(
					'default' => esc_html__( 'Default', 'onelisting' ),
					'on'      => esc_html__( 'Enabled', 'onelisting' ),
					'off'     => esc_html__( 'Disabled', 'onelisting' ),
				),
				'default'    => 'default',
				'dependency' => array( $prefix . '_banner', '!=', 'off' ),
			),
			array(
				'id'         => $prefix . '_bgtype',
				'type'       => 'select',
				'title'      => esc_html__( 'Banner Background Type', 'onelisting' ),
				'options'    => array(
					'default' => esc_html__( 'Default', 'onelisting' ),
					'bgcolor' => esc_html__( 'Background Color', 'onelisting' ),
					'bgimg'   => esc_html__( 'Background Image', 'onelisting' ),
				),
				'default'    => 'default',
				'dependency' => array( $prefix . '_banner', '!=', 'off' ),
			),
			array(
				'id'         => $prefix . '_bgimg',
				'type'       => 'media',
				'title'      => esc_html__( 'Banner Background Image', 'onelisting' ),
				'library'    => 'image',
				'url'        => false,
				'dependency' => array( $prefix . '_bgtype', '==', 'bgimg' ),
			),
			array(
				'id'          => $prefix . '_bgcolor',
				'type'        => 'color',
				'title'       => esc_html__( 'Banner Background Color', 'onelisting' ),
				'validate'    => 'color',
				'transparent' => false,
				'default'     => '',
				'dependency'  => array( $prefix . '_bgtype', '==', 'bgcolor' ),
			),
		),
	)
);