<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name      = Constants::$theme_options;
$primary_color = '#f51957';

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Colors', 'onelisting' ),
		'icon'   => 'fas fa-paint-brush',
		'fields' => array(
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Sitewide Colors', 'onelisting' ),
			),
			array(
				'id'          => 'primary_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Primary Color', 'onelisting' ),
				'default'     => '#f51957;',
			),
			array(
				'id'          => 'other_colors',
				'type'        => 'button_set',
				'transparent' => false,
				'title'       => esc_html__( 'Primary Color', 'onelisting' ),
				'options'     => array(
					'primary_color' => esc_html__( 'Primary Color', 'onelisting' ),
					'custom'        => esc_html__( 'Custom', 'onelisting' ),
				),
				'desc'        => esc_html__( 'Selecting Primary Color will hide some color options from the below settings and replace them with Primary color', 'onelisting' ),
				'default'     => 'primary_color',
			),
			array(
				'id'    => 'section-color-menu',
				'type'  => 'heading',
				'title' => esc_html__( 'Main Menu', 'onelisting' ),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'id'         => 'menu_text_colors',
				'type'       => 'color_group',
				'title'      => esc_html__( 'Main Menu Text', 'onelisting' ),
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
					'active'  => 'Active',
				),
				'default'    => array(
					'default' => '#51526e',
					'hover'   => $primary_color,
					'active'  => $primary_color,
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Banner Area', 'onelisting' ),
			),
			array(
				'id'      => 'banner_title_color',
				'type'    => 'color',
				'title'   => esc_html__( 'Banner Title', 'onelisting' ),
				'default' => '#ffffff',
			),
			array(
				'id'      => 'breadcrumb_seperator_color',
				'type'    => 'color',
				'title'   => esc_html__( 'Breadcrumb Seperator', 'onelisting' ),
				'default' => '#f8f9fb',
			),
			array(
				'id'         => 'breadcrumb_link_colors',
				'type'       => 'color_group',
				'title'      => esc_html__( 'Breadcrumb Link', 'onelisting' ),
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
					'active'  => 'Active',
				),
				'default'    => array(
					'default' => '#f8f9fb',
					'hover'   => $primary_color,
					'active'  => '#acabac',
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),

			array(
				'type'       => 'heading',
				'title'      => esc_html__( 'Add Listing Button', 'onelisting' ),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'id'         => 'add_listing_button_text_colors',
				'title'      => esc_html__( 'Button Text', 'onelisting' ),
				'type'       => 'color_group',
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
				),
				'default'    => array(
					'default' => '#ffffff',
					'hover'   => '#ffffff',
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'id'         => 'add_listing_button_bgcolors',
				'title'      => esc_html__( 'Button Background', 'onelisting' ),
				'type'       => 'color_group',
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
				),
				'default'    => array(
					'default' => $primary_color,
					'hover'   => $primary_color,
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),

			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Footer Area', 'onelisting' ),
			),
			array(
				'id'          => 'footer_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Background', 'onelisting' ),
				'default'     => '#ffffff',
			),
			array(
				'id'          => 'footer_divider_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Divider', 'onelisting' ),
				'default'     => '#eff1f6',
			),
			array(
				'id'          => 'footer_title_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Title', 'onelisting' ),
				'default'     => '#1a1b29',
			),
			array(
				'id'          => 'footer_text_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Text', 'onelisting' ),
				'default'     => '#605f74',
			),
			array(
				'id'         => 'footer_link_colors',
				'type'       => 'color_group',
				'title'      => esc_html__( 'Footer Link', 'onelisting' ),
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
				),
				'default'    => array(
					'default' => '#51526e',
					'hover'   => $primary_color,
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
		),
	)
);