<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Footer', 'onelisting' ),
		'icon'   => 'fas fa-angle-double-down',
		'fields' => array(
			array(
				'id'      => 'footer_area',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Footer Area', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'copyright_area',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Copyright Area', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'         => 'copyright_text',
				'type'       => 'textarea',
				'title'      => esc_html__( 'Copyright Text', 'onelisting' ),
				'default'    => sprintf( '&copy; OneListing %s. All rights reserved. Created by <a target="_blank" href="%s" rel="nofollow">wpWax</a>', date( 'Y' ), esc_url( Constants::$theme_author_uri ) ),
				'dependency' => array( 'copyright_area', '==', 'true' ),
			),
		),
	)
);