<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'General', 'onelisting' ),
		'icon'   => 'fas fa-globe-asia',
		'fields' => array(
			array(
				'id'      => 'preloader',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Preloader', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'         => 'preloader_image',
				'type'       => 'media',
				'title'      => esc_html__( 'Preloader Image', 'onelisting' ),
				'subtitle'   => esc_html__( 'Please upload your choice of preloader image. Transparent GIF format is recommended', 'onelisting' ),
				'library'    => 'image',
				'url'        => false,
				'dependency' => array( 'preloader', '==', 'true' ),
			),
		),
	)
);