<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Header', 'onelisting' ),
		'icon'   => 'fas fa-flag',
		'fields' => array(
			array(
				'id'       => 'resmenu_width',
				'type'     => 'slider',
				'title'    => esc_html__( 'Responsive Header Screen Width', 'onelisting' ),
				'subtitle' => esc_html__( 'Screen width in which mobile menu activated. Recommended value is: 991', 'onelisting' ),
				'default'  => 991,
				'min'      => 0,
				'step'     => 1,
				'max'      => 2000,
				'unit'     => 'px',
			),
			array(
				'id'      => 'container_type',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Header Style', 'onelisting' ),
				'options' => array(
					'theme-container-fluid' => Helper::get_img( 'header-container-fluid.png' ),
					'theme-container'       => Helper::get_img( 'header-container.png' ),
				),
				'default' => 'theme-container-fluid',
			),
			array(
				'id'      => 'header_search',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Header Search', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'header_account',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Header Account', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'add_listing_button',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Add Listing Button', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'         => 'add_listing_button_text',
				'type'       => 'text',
				'title'      => esc_html__( 'Add Listing Button Text', 'onelisting' ),
				'default'    => esc_html__( "Add Listing", 'onelisting' ),
				'dependency' => array( 'add_listing_button', '==', 'true' ),
			),
			array(
				'id'      => 'banner',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Banner', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'         => 'breadcrumb',
				'type'       => 'switcher',
				'title'      => esc_html__( 'Breadcrumb', 'onelisting' ),
				'default'    => false,
				'dependency' => array( 'banner', '==', 'true' ),
			),
			array(
				'id'         => 'bgtype',
				'type'       => 'button_set',
				'title'      => esc_html__( 'Banner Background Type', 'onelisting' ),
				'options'    => array(
					'bgcolor' => esc_html__( 'Background Color', 'onelisting' ),
					'bgimg'   => esc_html__( 'Background Image', 'onelisting' ),
				),
				'default'    => 'bgimg',
				'dependency' => array( 'banner', '==', 'true' ),
			),
			array(
				'id'          => 'bgcolor',
				'type'        => 'color',
				'title'       => esc_html__( 'Banner Background Color', 'onelisting' ),
				'validate'    => 'color',
				'transparent' => false,
				'default'     => '#f2f2f2',
				'dependency'  => array( 'bgtype', '==', 'bgcolor' ),
			),
			array(
				'id'         => 'bgimg',
				'type'       => 'media',
				'title'      => esc_html__( 'Banner Background Image', 'onelisting' ),
				'library'    => 'image',
				'url'        => false,
				'dependency' => array( 'bgtype', '==', 'bgimg' ),
			),
			array(
				'id'         => 'bgopacity',
				'type'       => 'slider',
				'title'      => esc_html__( 'Banner Background Opacity', 'onelisting' ),
				'min'        => 0,
				'max'        => 100,
				'step'       => 1,
				'default'    => 60,
				'unit'       => '%',
				'dependency' => array( 'bgtype', '==', 'bgimg' ),
			),
		),
	)
);