<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

if ( ! class_exists( 'CSF' ) ) {
	return;
}

// Add missing google fonts to csf
add_filter( 'csf_field_typography_googlewebfonts', function ( $fonts ) {
	$fonts['Nunito Sans'] = array( array( '400', '600' ), array( 'latin-ext', 'latin' ) );

	return $fonts;
} );

$prefix = Constants::$theme_options;
$theme  = wp_get_theme();

\CSF::createOptions( $prefix, array(
	'framework_title' => $theme->get( 'Name' ),
	'menu_title'      => esc_html__( 'Theme Options', 'onelisting' ),
	'menu_slug'       => Constants::$theme_prefix . '-options',
	'menu_type'       => 'submenu',
	'menu_parent'     => 'themes.php',
	'theme'           => 'dark',
	'footer_credit'   => ' ',
) );

Helper::requires( 'options/general.php' );
Helper::requires( 'options/header.php' );
Helper::requires( 'options/footer.php' );
Helper::requires( 'options/color.php' );
Helper::requires( 'options/typography.php' );
Helper::requires( 'options/layout.php' );

if ( class_exists( 'Directorist_Base' ) ) {
	Helper::requires( 'options/directorist.php' );
}

Helper::requires( 'options/blog.php' );
Helper::requires( 'options/post.php' );
Helper::requires( 'options/error.php' );
Helper::requires( 'options/export.php' );