<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name = Constants::$theme_options;

function wpwaxtheme_csf_post_type_fields( $prefix ) {
	return array(
		'layout'     => array(
			'id'      => $prefix . '_layout',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Layout', 'onelisting' ),
			'options' => array(
				'left-sidebar'  => esc_html__( 'Left Sidebar', 'onelisting' ),
				'full-width'    => esc_html__( 'No Sidebar', 'onelisting' ),
				'right-sidebar' => esc_html__( 'Right Sidebar', 'onelisting' ),
			),
			'default' => 'full-width',
		),
		'banner'     => array(
			'id'      => $prefix . '_banner',
			'type'    => 'select',
			'title'   => esc_html__( 'Banner', 'onelisting' ),
			'options' => array(
				'default' => esc_html__( 'Default', 'onelisting' ),
				'on'      => esc_html__( 'Enabled', 'onelisting' ),
				'off'     => esc_html__( 'Disabled', 'onelisting' ),
			),
			'default' => 'default',
		),
		'breadcrumb' => array(
			'id'         => $prefix . '_breadcrumb',
			'type'       => 'select',
			'title'      => esc_html__( 'Breadcrumb', 'onelisting' ),
			'options'    => array(
				'default' => esc_html__( 'Default', 'onelisting' ),
				'on'      => esc_html__( 'Enabled', 'onelisting' ),
				'off'     => esc_html__( 'Disabled', 'onelisting' ),
			),
			'default'    => 'default',
			'dependency' => array( $prefix . '_banner', '!=', 'off' ),
		),
		'bgtype'     => array(
			'id'         => $prefix . '_bgtype',
			'type'       => 'select',
			'title'      => esc_html__( 'Banner Background Type', 'onelisting' ),
			'options'    => array(
				'default' => esc_html__( 'Default', 'onelisting' ),
				'bgcolor' => esc_html__( 'Background Color', 'onelisting' ),
				'bgimg'   => esc_html__( 'Background Image', 'onelisting' ),
			),
			'default'    => 'default',
			'dependency' => array( $prefix . '_banner', '!=', 'off' ),
		),
		'bgimg'      => array(
			'id'         => $prefix . '_bgimg',
			'type'       => 'media',
			'title'      => esc_html__( 'Banner Background Image', 'onelisting' ),
			'library'    => 'image',
			'url'        => false,
			'dependency' => array( $prefix . '_bgtype', '==', 'bgimg' ),
		),
		'bgcolor'    => array(
			'id'          => $prefix . '_bgcolor',
			'type'        => 'color',
			'title'       => esc_html__( 'Banner Background Color', 'onelisting' ),
			'validate'    => 'color',
			'transparent' => false,
			'default'     => '',
			'dependency'  => array( $prefix . '_bgtype', '==', 'bgcolor' ),
		),
	);
}

\CSF::createSection( $opt_name,
	array(
		'title' => esc_html__( 'Layout Settings', 'onelisting' ),
		'id'    => 'layout_defaults',
		'icon'  => 'fas fa-th-large',
	)
);

// Page
$wpwaxtheme_page_fields = wpwaxtheme_csf_post_type_fields( 'page' );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Page', 'onelisting' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_page_fields,
	)
);

//Post Archive
$wpwaxtheme_post_archive_fields = wpwaxtheme_csf_post_type_fields( 'blog' );
$wpwaxtheme_post_archive_fields['layout']['default'] = 'right-sidebar';
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Blog / Archive', 'onelisting' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_post_archive_fields,
	)
);

// Single Post
$wpwaxtheme_single_post_fields                      = wpwaxtheme_csf_post_type_fields( 'single_post' );
$wpwaxtheme_single_post_fields['banner']['default'] = 'off';
$wpwaxtheme_single_post_fields['layout']['default'] = 'right-sidebar';
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Post Single', 'onelisting' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_single_post_fields,
	)
);

// Search
$wpwaxtheme_search_fields = wpwaxtheme_csf_post_type_fields( 'search' );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Search Layout', 'onelisting' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_search_fields,
	)
);

// Error 404 Layout
$wpwaxtheme_error_fields = wpwaxtheme_csf_post_type_fields( 'error' );
unset( $wpwaxtheme_error_fields['layout'] );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Error 404 Layout', 'onelisting' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_error_fields,
	)
);