<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Post Settings', 'onelisting' ),
		'icon'   => 'fas fa-edit',
		'fields' => array(
			array(
				'id'      => 'post_date',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Post Date', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'post_cats',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Categories', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'single_average_reading_time',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Reading Time', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'post_tags',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Tags', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'post_social',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Social Sharing', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'         => 'post_share',
				'type'       => 'checkbox',
				'class'      => 'redux-custom-inline',
				'title'      => esc_html__( 'Social Sharing Icons', 'onelisting' ),
				'options'    => array(
					'facebook'  => 'Facebook',
					'twitter'   => 'Twitter',
					'linkedin'  => 'Linkedin',
					'pinterest' => 'Pinterest',
					'tumblr'    => 'Tumblr',
					'reddit'    => 'Reddit',
					'vk'        => 'Vk',
					'copy_url'  => 'Copy URL',
				),
				'dependency' => array( 'post_social', '==', true ),
				'default'    => array( 'facebook', 'twitter', 'linkedin', 'copy_url' ),
			),
			array(
				'id'      => 'post_about_author',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display About Author', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'post_pagination',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Previous/Next Post Link', 'onelisting' ),
				'default' => true,
			),
			array(
				'id'      => 'post_related',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Related Posts', 'onelisting' ),
				'default' => true,
			),
		),
	)
);