<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\OneListing;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Typography', 'onelisting' ),
		'icon'   => 'fas fa-font',
		'fields' => array(
			array(
				'id'             => 'typo_body',
				'type'           => 'typography',
				'title'          => esc_html__( 'Body', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'subset'         => false,
				'text_transform' => false,
				'font_style'     => true,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '400',
					'font-size'   => '16',
					'font-style'  => 'normal',
				),
			),
			array(
				'id'             => 'typo_h1',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h1', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '600',
					'font-size'   => '30',
				),
			),
			array(
				'id'             => 'typo_h2',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h2', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '600',
					'font-size'   => '24',
				),
			),
			array(
				'id'             => 'typo_h3',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h3', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '600',
					'font-size'   => '22',
				),
			),
			array(
				'id'             => 'typo_h4',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h4', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '600',
					'font-size'   => '20',
				),
			),
			array(
				'id'             => 'typo_h5',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h5', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '600',
					'font-size'   => '18',
				),
			),
			array(
				'id'             => 'typo_h6',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h6', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '600',
					'font-size'   => '16',
				),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Main Menu Items', 'onelisting' ),
			),
			array(
				'id'             => 'menu_typo',
				'type'           => 'typography',
				'title'          => esc_html__( 'Menu Font', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '400',
					'font-size'   => '16',
				),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Sub Menu Items', 'onelisting' ),
			),
			array(
				'id'             => 'submenu_typo',
				'type'           => 'typography',
				'title'          => esc_html__( 'Submenu Font', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'line_height'    => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '400',
					'font-size'   => '14',
				),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Mobile Menu', 'onelisting' ),
			),
			array(
				'id'             => 'resmenu_typo',
				'type'           => 'typography',
				'title'          => esc_html__( 'Mobile Menu Font', 'onelisting' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'line_height'    => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Roboto',
					'font-weight' => '400',
					'font-size'   => '14',
				),
			),
		),
	)
);