<?php
/**
 * Return the default options of the theme
 * 
 * @return  void
 */

function themesflat_customize_default($key) {
	$default = array(
		'social_links'	=> array ("facebook" => '#', "twitter" => '#', "linkedin" => '#', "instagram" => '#'),
		'show_social_share' => 0,		
		'social_footer' => 0,
		'go_top' => 1,
		'topbar_background_color'	=> '#fff',
		'topbar_textcolor'	=> '#73787D',
		'topbar_link_color' => '#73787D',
		'topbar_link_color_hover' => '#FF3D3D',
		'topbar_show' => 0,
		
		'topbar_phone_label' => '<i class="onsus-icon-support"></i> Call us for free:',
		'topbar_phone' => '+1(800) 123 4567',
		'topbar_ship' => 'Free Shipping on Orders',
		'topbar_email_label' => 'Email:',
		'topbar_email' => 'oesus@support.com',
		'social_topbar' => 0,
		'menu_topbar' => 0,
		'profile_topbar' => 0,
		'language_topbar' => 1,
		'currency_topbar' => 1,
		'ship_topbar' => 1,

		'ship_header' => 1,

		'typography_topbar' => array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '13',
			'line_height'=>'1.92',
			'letter_spacing' => '',
		),
		'topbar_controls' => array('padding-top' => 0,'padding-bottom' => 0),
		'logo_controls' => array('padding-top' => '','padding-bottom' => ''),
		'style_header'	=> 'header-default',	
		'header_backgroundcolor'=>'#ffffff',
		'header_sticky' => 0,
		'header_search_box' => 1,
		'header_content_right' => '',
		'header_absolute'	=> 0,		
		'header_sidebar_toggler' => 0,
		'header_button_show' => 0,
		'header_button_text' => 'GET SOLUTION',
		'header_button_url' => '/contact-us',
		'header_info_phone_text' => 'Call us now:',
		'header_info_phone_number' => '+1(800) 123 4567',
		'header_email_label' => 'Email:',
		'header_email' => 'oesus@support.com',
		'header_ship' => 'Free Shipping on Orders',
		'header_currency' => '[x-currency-switcher id=356]',
		'header_category' => 1,
		'header_cart_icon' => 1,
		'header_cart_icon2' => 0,
		'header_compare_icon' => 0,
		'header_wishlist_icon' => 0,
		'show_post_navigator' => 0,
		'show_entry_footer_content'	=> 0,
		'logo_width' => 185,
		'menu_location_primary' => 'primary',
		'site_logo'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_logo_fixed'	=> THEMESFLAT_LINK . 'images/logo.png',
		'site_logo_mobile'	=> THEMESFLAT_LINK . 'images/logo.png',	
		'show_bottom' => 1,		
		'header_backgroundcolor_sticky'=>'#fff',		
		'primary_color'=>'#333E48',
		'secondary_color'=>'#004EC3',
		'accent_color'=>'#FF3D3D',
		'typography_body' => array(
			'family' => 'Inter',
			'style'  => 'regular',
			'size'   => '14',
			'line_height'=>'1.4',
			'letter_spacing' => '0px',
		),
		'body_text_color'=>'#73787D',
		'body_background_color' => '',
		'page_sidebar_layout' => 'fullwidth',
		'content_controls' => array('padding-top' => 30,'padding-bottom' => 30),
		'typography_menu' => array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '14',
			'line_height'=>'50px',
			'letter_spacing' => '0px',
		), 
		'mainnav_color'		=> '#333E48',
		'mainnav_hover_color'=>'#FF3D3D',
		'mainnav_active_color'=>'#FF3D3D',
		'menu_distance_between' => 15,
		'typography_sub_menu' => array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '14',
			'line_height'=>'22px',
			'letter_spacing' => '0px',
		),
		'sub_nav_color'		=>'#333E48',		
		'sub_nav_color_hover'	=>	'#FF3D3D',
		'sub_nav_background'=>'#ffffff',
		'sub_nav_background_hover'=>'rgba(255,255,255,0)',
		'sub_nav_border_color' => '#ECECEC',
		'typography_headings'	=> array(
			'family' => 'Inter',
			'style'  => '600',
			'line_height'=>'1.333',
			'letter_spacing' => '0px'		
		),
		'h1_size' => 50,
		'h2_size' => 22,
		'h3_size' => 18,
		'h4_size' => 16,
		'h5_size' => 15,
		'h6_size' => 14,
		'typography_blockquote' => array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '14',
			'line_height'=>'1.333',
			'letter_spacing' => '0px',
		),	
		'typography_blog_post_title' => array(
			'family' => 'Inter',
			'style'  => '600',
			'size'   => '18',
			'line_height'=>'1.333',
			'letter_spacing' => '0px',
		),
		'typography_blog_post_meta' => array(
			'family' => 'Poppins',
			'style'  => '400',
			'size'   => '12',
			'line_height'=>'1.8333',
			'letter_spacing' => '0px',
		),
		'typography_blog_post_buttons' => array(
			'family' => 'Inter',
			'style'  => '600',
			'size'   => '15',
			'line_height'=>'1.6',
			'letter_spacing' => '0px',
		),
		'typography_blog_single_title' => array(
			'family' => 'Inter',
			'style'  => '600',
			'size'   => '50',
			'line_height'=>'1.21',
			'letter_spacing' => '0px',
		),
		'typography_blog_single_comment_title' => array(
			'family' => 'Inter',
			'style'  => '600',
			'size'   => '22',
			'line_height'=>'1.136',
			'letter_spacing' => '0px',
		),
		'typography_sidebar_widget_title' => array(
			'family' => 'Inter',
			'style'  => '700',
			'size'   => '16',
			'line_height'=>'1.333',
			'letter_spacing' => '0px',
		),	
		'typography_footer_widget_title' => array(
			'family' => 'Poppins',
			'style'  => '600',
			'size'   => '18',
			'line_height'=>'1.5',
			'letter_spacing' => '0px',
		),	
		'typography_page_title'	=> array(
			'family' => 'Inter',
			'style'  => '600',
			'size'   => '50',
			'line_height'=>'1.333',
			'letter_spacing' => '0px',
		),
		'page_title_background_color' => '#fff',
		'page_title_background_color_opacity' => '100',
		'page_title_text_color' => '#73787D',		
		'page_title_controls' => array('padding-top' => 20, 'padding-bottom' => 20),
		'page_title_background_image' => '',
		'page_title_image_size' => 'cover',
		'page_title_heading_enabled' => 0,
		'typography_breadcrumb'	=> array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '13',
			'line_height'=>'1.923',
			'letter_spacing' => '0px',
		),
		'bread_crumb_prefix' =>'',
		'breadcrumb_separator' =>  wp_kses( '<span class="tfonsus-icon-right"></span>', themesflat_kses_allowed_html() ),
		'breadcrumb_color' => '#73787D',
		'typography_buttons' => array(
			'family' => 'Inter',
			'style'  => '600',
			'size'   => '15',
			'line_height'=>'1.6',
			'letter_spacing' => '0px',
		),
		'typography_pagination'	=> array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '22',
			'line_height'=>'1.363',
			'letter_spacing' => '0px',
		),		
		'typography_bottom_menu' => array(
			'family' => 'Inter',
			'style'  => '700',
			'size'   => '16',
			'line_height'=>'1.125',
			'letter_spacing' => '0px',
		),
		'breadcrumb_enabled' => 1,
		'show_post_paginator' => 1,
		'blog_grid_columns' => 3,
		'post_content_elements' => 'meta,title,excerpt_content',
		'meta_elements' => 'author,date',
		'blog_archive_exclude' => '',
		'blog_featured_title' => '',
		'sidebar_layout' => 'sidebar-right',
		'blog_archive_layout' => 'blog-list',
		'show_related_post'	=> 1,
		'related_post_style'	=> 'blog-grid',
		'grid_columns_post_related' => 3,
		'number_related_post' => 3,
		'blog_sidebar_list'		  => 'blog-sidebar',	
		'blog_archive_readmore' => 0,
		'blog_archive_post_excepts_length' => 15,
		'blog_archive_readmore_text' => '',
		'blog_archive_pagination_style' => 'pager-numeric',
		'blog_posts_per_page'	=> 3,
		'blog_order_by'	=> 'date',
		'blog_order_direction' => 'DESC',
		'page_sidebar_list'	=> 'blog-sidebar',		
		
		'show_featured_single'	=> 0,


		'show_related_products'	=> 0,
		'number_related_product_desk' => 4,
		'number_related_product_tab' => 2,
		'number_related_product_mob' => 2,
		'number_related_product_mob2' => 1,

		'portfolio_slug' => '',
		'portfolio_name' => '',
		'portfolio_show_filter' => 0,
		'portfolio_grid_columns' => 3,
		'portfolios_number_post'=> 9,
		'portfolio_filter_category_order' => '',
		'portfolio_order_by' => 'date',
		'portfolio_order_direction' => 'DESC',
		'portfolio_exclude' => '',
		'portfolios_layout' => 'fullwidth',
		'portfolios_show_post_navigator' => 0,
		'portfolios_show_related' => 0,
		'portfolios_related_grid_columns' => 3,
		'portfolios_sidebar_list' => 'blog-sidebar',
		'portfolio_post_image'	=> THEMESFLAT_LINK . 'images/logo.png',
		'number_related_post_portfolios' => 3,
		'portfolios_featured_title' => 'Portfolio Details',


		'project_number_post'=> 9,

		'services_slug' => '',
		'services_name' => '',
		'services_show_filter' => 0,
		'services_grid_columns' => 2,
		'services_number_post'=> 6,
		'services_archive_pagination_style' => 'pager-numeric',
		'services_filter_category_order' => '',
		'services_order_by' => 'date',
		'services_order_direction' => 'DESC',
		'services_exclude' => '',
		'services_layout' => 'sidebar-left',
		'services_sidebar_list' => 'themesflat-custom-sidebar-servicessidebar',
		'services_show_post_navigator' => 1,
		'services_show_related' => 0,
		'services_related_grid_columns' => 3,
		'number_related_post_services' => 3,
		'services_featured_title' => 'Services Details',

		'team_slug' => '',
		'team_name' => '',
		'team_grid_columns' => 4,
		'team_number_post'=> 4,
		'team_archive_pagination_style' => 'pager-numeric',
		'team_order_by' => 'date',
		'team_order_direction' => 'DESC',
		'team_exclude' => '',
		'team_featured_title' => 'Team Details',
		
		'typography_footer' => array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '15',
			'line_height'=>'1.6',
			'letter_spacing' => '',
		),
		'footer_background_color'	=> '#FAFAFA',
		'footer_title_widget_color' => '#333E48',
		'footer_text_color'			=> '#333E48',
		'footer_text_color_hover'   => '#004EC3',
		'footer_widget_areas' => 5,
		'footer_controls' => array('padding-top' => 0, 'padding-bottom' => 0),
		'footer1' => 'footer-1',
		'footer2' => 'footer-2',
		'footer3' => 'footer-3',
		'footer4' => 'footer-4',
		'footer_background_image' => '',
		'footer_image_size' => 'auto',
		'typography_bottom_copyright' => array(
			'family' => 'Inter',
			'style'  => '400',
			'size'   => '12',
			'line_height'=>'1.8333',
			'letter_spacing' => '',
		),
		'bottom_background_color'	=> '#FAFAFA',
		'bottom_text_color'			=> '#333E48',
		'bottom_link_color'         => '#333E48',
		'bottom_text_color_hover'   => '#004EC3',		
		'layout_version'			=> 'wide',		
		'footer_copyright'			=> 'Copyright © 2022 The Onsus – Electronics Ecommerce WordPress Theme. Designed by <a href="https://themeforest.net/user/themesflat/portfolio">Themesflat</a>',
		'enable_smooth_scroll'	=> 0,
		'enable_preload' => 1,
		'preload' => 'preload-1',
		'page_title_styles' => 'parallax',
		'page_title_alignment' => 'left',
		'page_title_video_url' => '',		
		'show_action_box'	=> 0,
		'heading_action_box'	=>	'Solve Your IT Needs Today!',
		'text_action_box'	=>	'',
        'text_button_action_box'	=> 'GET SOLUTIONS',
        'action_box_background_image' =>  THEMESFLAT_LINK . 'images/bg-actionbox.jpg',
        'action_box_background_color' => 'rgba(0, 176 ,252,0.95)',
        'action_box_heading_color' => '#ffffff',
        'action_box_text_color'	=> '#ffffff',
        'action_box_button_text_color' => '#ffffff',
        'action_box_button_background_color' => 'rgba(0,0,0,0)',
		'action_box_button_url' => '/contact-us',
        'show_partner'	=> 0,
		'img_partner' => '',
		'show_number_img_partner_desktop' => 6,
		'show_number_img_partner_tablet' => 4,
		'show_number_img_partner_mobile' => 2,
		'gap_img_partner' => 30,
		'partner_box_controls' => array('padding-top' => 67,'padding-bottom' => 106),
		'partner_box_background_color' => '#00b0fc',
        'show_footer_info'	=> 0,
        'footer_info_text' => 'Solve Your IT Needs Today!',
		'footer_info_button_url' => '/contact-us',
        'footer_info_button' => 'GET SOLUTIONS',
        //Woo
		'show_top_category' => 1,
		'category_dek' => 8,
		'category_tab' => 4,
		'category_mob' => 3,
		'category_mob2' => 2,

		'catalog_toolbar' => 1,
		'catalog_view' => 1,
		'catalog_btn_change' => 1,
		'catalog_sort_by' => 1,

		'show_sku'	=> 1,

		'shop_pagination' => 'number',
		'shop_loadmore_text' => 'Load More',

        'shop_products_per_page' => 8,
        'shop_columns' => 4,
        'shop_layout' => 'sidebar-left',
		'shop_style' => 'grid',
        'shop_layout_single' => 'fullwidth',
        'related_products' => 1,
        'related_products_columns' => 5,
        'product_featured_title' => '',
        'product_style' => 'product-style1',
		'show_thumb' => 1,
		'show_cowndown' => 0,
		'show_progress' => 1,
		'show_configuration' => 1,
		'show_delivery' => 1,

		'show_popup_form' => 1,
		'shortcode_mailchimp' => '[mc4wp_form id=369]',
		'img_popup'	=> THEMESFLAT_LINK . 'images/popup.jpg',
        'popup_heading' => 'Enjoy 10% off your first order when you sign up for emails and texts*',
        'popup_des' => 'Buy submitting this form, you agree to receive recurring, automated promotional and personalized marketing text message (e.g. cart reminders) from wayfair at the cell number used when signing up. Consent is not a condition of any purchase. Reply HELP for help and STOP to cancel. Msg fre quency varies, Msg and data rates may apply. View Terms & Privacy policy. You can change your communication preferences at any time. *Exclusions apply. See exclusions.',

		
		
	);
	return $default[$key];
}