<?php
/**
 * Oxygen WordPress Theme
 *
 * Laborator.co
 * www.laborator.co
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Build number
define( 'OXYGEN_BUILD_NUM', 1763975244 );

// Theme content width
$GLOBALS['content_width'] = isset( $GLOBALS['content_width'] ) ? $GLOBALS['content_width'] : 1170;

// Theme demo file
if ( file_exists( get_stylesheet_directory() . '/theme-demo/theme-demo.php' ) ) {
	require "theme-demo/theme-demo.php";
}

// Core files
require 'inc/lib/smof/smof.php';
require 'inc/laborator_classes.php';
require 'inc/laborator_functions.php';
require 'inc/laborator_actions.php';
require 'inc/laborator_filters.php';
require 'inc/laborator_wpb.php';
require __DIR__ . '/inc/class-oxygen-freemius.php';

// Advanced Custom Fields
require 'inc/acf-fields.php';

// WooCommerce integration
if ( oxygen_is_shop_supported() ) {
	require_once 'inc/woocommerce-core.php';
	require_once 'inc/woocommerce-loop.php';
	require_once 'inc/woocommerce-single.php';
	require_once 'inc/woocommerce-cart.php';
	require_once 'inc/woocommerce-checkout.php';
	require_once 'inc/woocommerce-other.php';
}

// Library Files
require 'inc/lib/dynamic_image_downsize.php';
require 'inc/lib/class-tgm-plugin-activation.php';
require 'inc/lib/laborator/laborator_custom_css.php';
require 'inc/lib/laborator/laborator-demo-content-importer/laborator_demo_content_importer.php';

// Visual Composer
if ( oxygen_is_plugin_active( 'js_composer/js_composer.php' ) || defined( 'WPB_VC_VERSION' ) ) {
	require 'inc/lib/visual-composer/config.php';
}

// Revslider Field for ACF
if ( oxygen_is_plugin_active( 'revslider/revslider.php' ) && function_exists( 'register_field_group' ) ) {
	require 'inc/lib/acf-revslider/acf-revslider.php';
}

// Laborator SEO
if ( ! defined( 'WPSEO_PATH' ) ) {
	require 'inc/lib/laborator/laborator_seo.php';
}

// Thumbnail sizes
add_image_size( 'blog-thumb-1', 410, 410, true );
add_image_size( 'shop-thumb-2', 180, 220, true );
add_image_size( 'blog-thumb-3', 540, 360, true );

if ( ! function_exists( 'oxygen_fs' ) ) {
	// Create a helper function for easy SDK access.
	function oxygen_fs() {
		global $oxygen_fs;

		if ( ! isset( $oxygen_fs ) ) {
			// Include Freemius SDK.
			require_once __DIR__ . '/vendor/autoload.php';

			$oxygen_fs = fs_dynamic_init( array(
				'id'                  => '16745',
				'slug'                => 'oxygen-theme',
				'premium_slug'        => 'oxygen',
				'type'                => 'theme',
				'public_key'          => 'pk_e51425efdcab29b9ed2478678884c',
				'is_premium'          => true,
				'is_premium_only'     => true,
				'has_addons'          => false,
				'has_paid_plans'      => true,
				'is_org_compliant'    => false,
				'menu'                => array(
					'slug'           => 'laborator_options',
					'contact'        => false,
					'support'        => false,
				),
			) );
		}

		return $oxygen_fs;
	}

	// Init Freemius.
	oxygen_fs();
	// Signal that SDK was initiated.
	do_action( 'oxygen_fs_loaded' );
}
