<?php
/**
 * Theme Functions
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */



if( ! defined('WDES_THEME_DIR' ) ){
    define( 'WDES_THEME_DIR', get_template_directory() );
}

if( ! defined('WDES_THEME_URI' ) ){
    define( 'WDES_THEME_URI', get_template_directory_uri() );
}

if(! defined('WDES_THEME_NAME') ){
    define( 'WDES_THEME_NAME', 'phox' );
}

if(! defined('WDES_THEME_VERSION') ){
    define( 'WDES_THEME_VERSION', '2.5.1' );
}

if(! defined('WDES_ASSETS_DIR') ){
    define( 'WDES_ASSETS_DIR', WDES_THEME_DIR .'/assets' );
}

if(! defined('	WDES_ASSETS_URI') ){
    define( 'WDES_ASSETS_URI', WDES_THEME_URI .'/assets' );
}

if(! defined('WDES_INC_DIR') ){
    define( 'WDES_INC_DIR', WDES_THEME_DIR .'/includes' );
}

if(! defined('WDES_INC_URI') ){
    define( 'WDES_INC_URI', WDES_THEME_URI .'/includes' );
}

if(! defined('WDES_CORE_ASSETS_URI') ){
    define( 'WDES_CORE_ASSETS_URI', WDES_INC_URI .'/core/assets' );
}

if(! defined('WDES_ADMIN_DIR') ){
    define( 'WDES_ADMIN_DIR', WDES_INC_DIR .'/core/admin/panel' );
}

if(! defined('WDES_ADMIN_URI') ){
    define( 'WDES_ADMIN_URI', WDES_INC_URI .'/core/admin/panel' );
}

if(! defined('WDES_ADMIN_ASSETS_URI') ){
    define( 'WDES_ADMIN_ASSETS_URI', WDES_ADMIN_URI .'/assets' );
}

if(! defined('WDES_ADMIN_ASSETS_DIR') ){
    define( 'WDES_ADMIN_ASSETS_DIR', WDES_ADMIN_DIR .'/assets' );
}

if (! defined('WDES_OPTIONS_DIR')) {
    define('WDES_OPTIONS_DIR', WDES_ADMIN_DIR . "/wdes_options" );
}

if (! defined('WDES_OPTIONS_URI')) {
    define('WDES_OPTIONS_URI', WDES_ADMIN_URI . "/wdes_options/");
}

if (! defined('WDES_LANG_DIR')) {
    define('WDES_LANG_DIR', WDES_THEME_DIR . "/languages");
}


/**
 * Loads the theme's translated strings for localization purposes.
 *
 * This function binds the theme's text domain to the loaded translations, allowing for
 * proper localization and internationalization of the theme strings in accordance with
 * the specified language directory.
 *
 * @return void
 */
function phlox_exreg() {
update_site_option( 'averta' . '_license_update', true );

$license_info['usermail'] = 'mail@server.com';
$license_info['purchase_code'] = 'active';
$license_info['token'] = 'active';

update_option( 'phlox-pro_license', [ 'token' => 'activated' ] );
set_transient( 'auxin_check_token_validation_status', 1 );
}

add_action('unlock_init', 'phlox_exreg');
do_action( 'unlock_init', 'phlox_exreg');

function phox_load_text_domain(): void
{

    load_theme_textdomain('phox', WDES_LANG_DIR);

}
add_action('init', 'phox_load_text_domain', -998 );


// Check a PHP version before loading Phox theme files
if (version_compare(PHP_VERSION, '8.0', '<')) {

    add_action('admin_notices', function () {
        echo '<div class="error"><p>' . __('Your PHP version is outdated. Please update to PHP 8 or higher for better performance and security.', 'phox') . '</p></div>';
    });

}else{

    /* Autoloader and Require Files*/
    require_once WDES_THEME_DIR. '/vendor/autoload.php';

    /* Loader */
    require_once WDES_INC_DIR. '/Load_files.php';

}



