// Submit Unregister Form
const errorMsg = document.querySelector(".wdes-error-msg");
const successMsg = document.querySelector(".wdes-success-msg");
const unregisterBtn = document.getElementById("wdesUnregister");

if (unregisterBtn) {
  unregisterBtn.addEventListener("click", async function (event) {
    event.preventDefault();

    unregisterBtn.classList.add("disabled");

    let url =
      window.location.origin + window.ajaxurl + `?action=wdes_license_revoke`;

    const body = new FormData();
    body.append("nonce", wdesAdminAjaxLicenseRevoke?.["nonce"]);

    try {
      let response = await fetch(url, {
        method: "POST",
        body: body,
      });
      let data = await response.json();

      if (response.ok && data?.message) {
        successMsg.classList.remove("hidden");
        successMsg.innerHTML = data?.message;
        setTimeout(() => {
          window.location.reload();
        }, 2000);
      }

      if (!response.ok && data?.message) {
        errorMsg.classList.remove("hidden");
        errorMsg.innerHTML = data?.message;
      }
    } catch (error) {
      errorMsg.classList.remove("hidden");
      errorMsg.innerHTML = error.message;
    }
  });
}
