<?php
if( ! defined( 'ABSPATH' ) ){
    exit; //Exit if accessed directly
}

/** @var array $vars */
$template_vars = $vars;
?>

<!-- Header -->
<div class="wdes-phox-home">
    <div class="wdes-phox-home-logo">
        <a class="wdes-phox-home-logo-wrapper" href="<?php echo $template_vars['dashborad_url'] ?>">
            <img class="wdes-phox-home-logo_img" src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/logo-shade.png' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>" />
        </a>
        <div class="wdes-phox-home-version">
            <h1 class="wdes-phox-home-title"><?php esc_html_e( 'Welcome to Phox', 'phox' ); ?></h1>
            <div class="wdes-phox-home-version-wrapper">
                <div class="wdes-phox-home-version_block">
                    <span><?php echo esc_html( 'Version '. WDES_THEME_VERSION ); ?></span>
                </div>
                <div class="wdes-phox-home-version_block">
                    <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/checkmark-circle.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                    <span><?php esc_html_e( 'Active', 'phox' ); ?></span>
                </div>
            </div>
        </div>
    </div>

    <div class="wdes-phox-home-menu">
        <ul class="wdes-phox-home-menu_nav">
            <li><a href="<?php echo $template_vars['builder_url'] ?>"><img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/dashboard-black.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>" /><span>Theme Builder</span></a></li>
            <li><a href="<?php echo $template_vars['theme_option_url'] ?>"><img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/settings.svg' ); ?>" alt="<?php esc_attr_e('Theme Options', 'phox'); ?>" /><span>Theme Options</span></a></li>
            <li><a href="<?php echo $template_vars['import_plugin_url'] ?>"><img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/add-browser.svg' ); ?>" alt="<?php esc_attr_e('Demo Import', 'phox'); ?>" /><span>Demo Import</span></a></li>
        </ul>
    </div>

    <div class="wdes-phox-home-ations">
        <ul class="wdes-phox-home-ations_nav">
            <li>
                <a target="_blank" href="https://phox.whmcsdes.com/docs/phox-changelog/">
                    <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/flag.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>" />
                    <span><?php esc_html_e( 'Changelog', 'phox' ); ?></span>
                </a>
            </li>
            <li>
                <a class="wdes-phox-home-ations_nav_docs" target="_blank" href="https://phox.whmcsdes.com/docs/">
                    <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/book.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                </a>
            </li>
        </ul>
    </div>
</div>

<!-- Content -->
<div class="wdes-phox-home-content">
    <div class="wdes-phox-home-content-wrapper">
        <!-- Server Status -->
        <div class="wdes-phox-home-content-block">
            <!-- Heading -->
            <div class="wdes-phox-home-content-block_heading">
                <h3><?php esc_html_e( 'Server Status', 'phox' ); ?></h3>
                <p><?php esc_html_e( 'Check the requirements of your server.', 'phox' ); ?></p>
            </div>
            <!-- Table -->
            <div class="wdes-phox-home-content-block_table">
                <table>
                    <thead>
                        <tr>
                            <th><?php esc_html_e( 'Environment', 'phox' ); ?></th>
                            <th><?php esc_html_e( 'Value', 'phox' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                        <tr>
                            <td><?php esc_html_e( 'Server Info', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ($template_vars['data']['server']) ; ?></span>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td><?php esc_html_e( 'PHP Version', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if($template_vars['status']['php']): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php echo PHP_VERSION ?></span>
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-note"><?php esc_html_e('WordPress requires PHP version 8.1 to 8.3.', 'phox') ?> <a target="_blank" href="https://wordpress.org/about/requirements/"><?php esc_html_e('Learn more', 'phox') ?></a></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'PHP Memory Limit', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['memory_limit'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php echo size_format( $template_vars['data']['memory_limit'] ); ?></span>
                                    <?php else: ?>
                                        <?php if( $template_vars['data']['memory_limit'] < 134217728 ): ?>
                                            <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                            <span class="wdes-phox-table-content-inner-value"><?php echo size_format( $template_vars['data']['memory_limit'] ); ?></span>
                                            <span class="wdes-phox-table-content-inner-note"><?php esc_html_e('Minimum', 'phox') ?> <strong><?php esc_html_e('128 MB', 'phox') ?></strong><?php esc_html_e(' is required, ', 'phox') ?><strong><?php esc_html_e('256 MB', 'phox') ?></strong><?php esc_html_e(' is recommended.', 'phox') ?> </span>
                                        <?php else: ?>
                                            <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/info.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                            <span class="wdes-phox-table-content-inner-value"><?php echo size_format( $template_vars['data']['memory_limit'] ); ?></span>
                                            <span class="wdes-phox-table-content-inner-info"><?php esc_html_e('Current memory limit is OK, however', 'phox') ?> <strong><?php esc_html_e('256 MB', 'phox') ?></strong><?php esc_html_e(' is recommended.', 'phox') ?></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'PHP Time Limit', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['time_limit'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ($template_vars['data']['time_limit']); ?></span>
                                    <?php else: ?>
                                        <?php if( $template_vars['data']['time_limit'] < 60 ): ?>
                                            <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                            <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text($template_vars['data']['time_limit']) ; ?></span>
                                            <span class="wdes-phox-table-content-inner-note"><?php esc_html_e('Minimum', 'phox') ?> <strong><?php esc_html_e('60', 'phox') ?></strong><?php esc_html_e(' is required,', 'phox') ?> <strong><?php esc_html_e(' 180', 'phox') ?></strong><?php esc_html_e(' is recommended.', 'phox') ?></span>
                                        <?php else: ?>
                                            <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/info.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                            <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ($template_vars['data']['time_limit']); ?></span>
                                            <span class="wdes-phox-table-content-inner-info"><?php esc_html_e('Current time limit is OK, however', 'phox') ?><strong><?php esc_html_e(' 180', 'phox') ?></strong><?php esc_html_e(' is recommended. ', 'phox') ?></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'PHP Max Input Vars', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['max_input_vars'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ($template_vars['data']['max_input_vars']); ?></span>
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ($template_vars['data']['max_input_vars']); ?></span>
                                        <span class="wdes-phox-table-content-inner-note"><?php esc_html_e(' Minimum 5000 is required ', 'phox') ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'Upload Max File Size', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['upload_max_filesize'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ( size_format( $template_vars['data']['upload_max_filesize'] ) ); ?></span>
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ( size_format( $template_vars['data']['upload_max_filesize'] ) ); ?></span>
                                        <span class="wdes-phox-table-content-inner-note"><?php esc_html_e(' 8 MB is required ', 'phox') ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'Post Max Size', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['post_max_size'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ( size_format( $template_vars['data']['post_max_size'] ) ); ?></span>
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php x_wdes()->wdes_get_text ( size_format( $template_vars['data']['post_max_size'] ) ); ?></span>
                                        <span class="wdes-phox-table-content-inner-note"><?php esc_html_e(' 8 MB is required ', 'phox') ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'cURL', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['curl'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-note"><?php esc_html_e('Your server does not have ', 'phox') ?><strong><?php esc_html_e('cURL', 'phox') ?></strong><?php esc_html_e('enabled. Please contact your hosting provider.', 'phox') ?></span>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'fsockopen/cUrl', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['fsockopen'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'Whois Server', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['fsockopen'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>

                        <tr>
                            <td><?php esc_html_e( 'ICU Version', 'phox' ); ?></td>
                            <td>
                                <div class="wdes-phox-table-content-inner">
                                    <?php if( $template_vars['status']['icu_version'] ): ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                        <span class="wdes-phox-table-content-inner-value"><?php esc_html_e('Version: '. INTL_ICU_VERSION , 'phox'); ?></span>
                                    <?php else: ?>
                                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                                            <?php if(defined('INTL_ICU_VERSION')): ?>
                                                <span class="wdes-phox-table-content-inner-note"><?php esc_html_e('We required Version 4.6 or higher, you need to contact your hosting provider, your version now is '. INTL_ICU_VERSION .'', 'phox'); ?></span>
                                            <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Quick Access -->
        <div class="wdes-phox-home-content-block">
            <!-- Heading -->
            <div class="wdes-phox-home-content-block_heading">
                <h3><?php esc_html_e( 'Quick Access', 'phox' ); ?></h3>
                <p><?php esc_html_e( 'Find below some useful links.', 'phox' ); ?></p>
            </div>
            <!-- Content -->
            <div class="wdes-phox-home-content-block_quick-access">
                <!-- Block -->
                <div class="wdes-phox-home-content-block_quick-access-block">
                    <h5 class="wdes-phox-home-content-block_quick-access-block_heading"><?php esc_html_e( 'Theme Builder', 'phox' ); ?></h5>
                    <ul class="wdes-phox-home-content-block_quick-access-block_wrapper">
                        <li>
                            <a href="<?php echo $template_vars['builder_url'] ?>">
                                <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/layout-header.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>">
                                <span><?php esc_html_e( 'Headers', 'phox' ); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo $template_vars['builder_footer_url'] ?>">
                                <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/layout-footer.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>">
                                <span><?php esc_html_e( 'Footers', 'phox' ); ?></span>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo $template_vars['builder_popup_url'] ?>">
                                <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/layout-popup.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>">
                                <span><?php esc_html_e( 'Popups', 'phox' ); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Block -->
                <div class="wdes-phox-home-content-block_quick-access-block">
                    <h5 class="wdes-phox-home-content-block_quick-access-block_heading"><?php esc_html_e( 'Useful Links', 'phox' ); ?></h5>
                    <ul class="wdes-phox-home-content-block_quick-access-block_wrapper">
                        <li>
                            <a target="_blank" href="https://whmcsdes.com/ca/submitticket.php?step=2&deptid=2">
                                <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/support.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>">
                                <span><?php esc_html_e( 'Support', 'phox' ); ?></span>
                            </a>
                        </li>
                        <li>
                            <a target="_blank" href="https://phox.whmcsdes.com/docs">
                                <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/book.svg' ); ?>" alt="<?php esc_attr_e('Theme Builder', 'phox'); ?>">
                                <span><?php esc_html_e( 'Documentation', 'phox' ); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Documentation -->
        <div class="wdes-phox-home-content-block">
            <!-- Heading -->
            <div class="wdes-phox-home-content-block_heading">
                <h3><?php esc_html_e( 'Documentation', 'phox' ); ?></h3>
                <p><?php esc_html_e( 'Check help articles and tutorials.', 'phox' ); ?></p>
            </div>
            <!-- Content -->
            <div class="wdes-phox-home-content-block_docs">
                <!-- Block -->
                <div class="wdes-phox-home-content-block_quick-access-block">
                    <h5 class="wdes-phox-home-content-block_quick-access-block_heading"><?php esc_html_e( 'Getting Started', 'phox' ); ?></h5>
                    <ul class="wdes-phox-home-content-block_docs_links">
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/importing-phox-demos/"><?php esc_html_e( 'Importing Phox Demos', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/creating-website-header/"><?php esc_html_e( 'Creating website Header', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/creating-website-footer/"><?php esc_html_e( 'Creating website Footer', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-create-a-new-popup-template-from-scratch/"><?php esc_html_e( 'Creating website Popup', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-update-the-theme/"><?php esc_html_e( 'Update The Theme', 'phox' ); ?></a></li>
                    </ul>
                </div>

                <!-- Block -->
                <div class="wdes-phox-home-content-block_quick-access-block">
                    <h5 class="wdes-phox-home-content-block_quick-access-block_heading"><?php esc_html_e( 'FAQ', 'phox' ); ?></h5>
                    <ul class="wdes-phox-home-content-block_docs_links">
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-uninstall-a-demo/"><?php esc_html_e( 'How to uninstall a demo?', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-use-whmcs-with-domain-widget/"><?php esc_html_e( 'How To Use WHMCS With Domain Widget', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-use-godaddy-reseller-store-with-domain-widget/"><?php esc_html_e( 'How To Use Godaddy Reseller Store With Domain Widget', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-do-i-unregister-a-license-on-a-website/"><?php esc_html_e( 'How Do I Unregister A License On A Website?', 'phox' ); ?></a></li>
                        <li><a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-use-wpforms-with-domain-widget/"><?php esc_html_e( 'How To Use WPForms With Domain Widget', 'phox' ); ?></a></li>
                    </ul>
                </div>
            </div>

        </div>
    </div>

    <div class="wdes-phox-home-content-wrapper">
        <!-- License Information -->
        <div class="wdes-phox-home-content-block wdes-phox-home-content-block--full-width">
            <!-- Heading -->
            <div class="wdes-phox-home-content-block_heading">
                <h3><?php esc_html_e( 'License Information', 'phox' ); ?></h3>
            </div>
            <!-- Content -->
            <div class="wdes-phox-home-content-block-wrap-unregister">
                <div class="wdes-phox-home-content-block_code"><?php x_wdes()->wdes_get_text ($template_vars['purchase_code']) ; ?></div>
            </div>

            <!-- Error Message -->
            <div class="wdes-error-msg hidden"></div>

            <!-- Success Message -->
            <div class="wdes-success-msg hidden"></div>
        </div>
    </div>
</div>