<?php
if( ! defined( 'ABSPATH' ) ){
    exit; //Exit if accessed directly
}

/** @var array $vars */
$template_vars = $vars;
?>
<?php if( empty($template_vars)  ): ?>
<div class="wdes-panel-block">
    <!-- Activate -->
    <div class="wdes-panel-wrapper">
        <!-- Heading -->
        <div class="wdes-panel-wrapper_heading">
            <h1><?php esc_html_e( 'Theme Activation', 'phox' ); ?></h1>
            <p><?php esc_html_e( 'Activate the theme license to access all features', 'phox' ); ?></p>
            <a id="activateBtn" class="btn btn-primary" href="<?php echo esc_url(\Phox\core\License_Activation::WDES_PORTAL_URL); ?>">
                <?php esc_html_e( 'Activate Theme', 'phox' ); ?>
                <?php $arrow = WDES_ADMIN_ASSETS_URI . '/img/arrow-up.svg'; ?>
                <?php echo '<img class="wdes-panel-wrapper_heading_btn_arrow" src="'. esc_url($arrow) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
            </a>
        </div>

        <!-- Steps -->
        <div class="wdes-panel-steps">
            <!-- Step -->
            <div class="wdes-panel-step">
                <div class="wdes-panel-step-thumb">
                    <?php $step1 = WDES_ADMIN_ASSETS_URI . '/img/step1.svg'; ?>
                    <?php echo '<img src="'. esc_url($step1) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
                </div>
                <div class="wdes-panel-step-content"><?php esc_html_e('1. Create or login to your wdes account.', 'phox') ?></div>
            </div>

            <!-- Step -->
            <div class="wdes-panel-step">
                <div class="wdes-panel-step-thumb">
                    <?php $step2 = WDES_ADMIN_ASSETS_URI . '/img/step2.svg'; ?>
                    <?php echo '<img src="'. esc_url($step2) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
                </div>
                <div class="wdes-panel-step-content"><?php esc_html_e('2. Synchronize account with Envato to add licenses.', 'phox') ?></div>
            </div>

            <!-- Step -->
            <div class="wdes-panel-step">
                <div class="wdes-panel-step-thumb">
                    <?php $step2 = WDES_ADMIN_ASSETS_URI . '/img/step3.svg'; ?>
                    <?php echo '<img src="'. esc_url($step2) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
                </div>
                <div class="wdes-panel-step-content"><?php esc_html_e('3. Activate the theme and start building your site.', 'phox') ?></div>
            </div>
        </div>

        <!-- Guide -->
        <div class="wdes-panel-guide">
            <a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-install-phox-via-ftp/">
                <?php esc_html_e( 'For assistance check installation article', 'phox' ); ?>
            </a>
        </div>

    </div>
</div>
<?php else: ?>
    <div class="wdes-panel-block">
        <!-- Activate -->
        <div class="wdes-panel-wrapper">
            <?php if( isset($template_vars['status']) ): ?>
                <?php if( $template_vars['status'] == 'true' ): ?>
                    <!-- Heading -->
                    <div class="wdes-panel-wrapper_heading">
                        <img class="exclamation" src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/success.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <h1><?php esc_html_e( 'Activated successfully', 'phox' ); ?></h1>
                        <p><?php esc_html_e('Theme activated successfully! Next, install plugins', 'phox'); ?></p>
                        <a class="btn btn-primary" href="https://wdes.org/" target="_blank">
                            <?php esc_html_e( 'Start Plugins Setup', 'phox' ); ?>
                            <?php $arrow = WDES_ADMIN_ASSETS_URI . '/img/arrow-up.svg'; ?>
                            <?php echo '<img class="wdes-panel-wrapper_heading_btn_arrow" src="'. esc_url($arrow) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
                        </a>
                    </div>
                <?php else: ?>
                    <!-- Heading -->
                     <div class="wdes-panel-wrapper_heading">
                        <img class="exclamation" src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/wrong.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <h1><?php esc_html_e( 'Something went wrong!', 'phox' ); ?></h1>
                        <p><?php echo $template_vars['message'] ?></p>
                        <a class="btn btn-primary" href="https://wdes.org/" target="_blank">
                            <?php esc_html_e( 'Register on our platform', 'phox' ); ?>
                            <?php $arrow = WDES_ADMIN_ASSETS_URI . '/img/arrow-up.svg'; ?>
                            <?php echo '<img class="wdes-panel-wrapper_heading_btn_arrow" src="'. esc_url($arrow) .'" alt="'.esc_attr__('Phox', 'phox').'">';?>
                        </a>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <?php if( isset($template_vars['plugins']) && $template_vars['plugins']): ?>
                <!-- Heading -->
                <div class="wdes-panel-wrapper_heading">
                    <h1><?php esc_html_e( 'Install Plugins', 'phox' ); ?></h1>
                    <p><?php esc_html_e( 'Install plugins needed for your website', 'phox' ); ?></p>
                </div>

                <!-- Plugins -->
                <div class="wdes-panel-plugins-list">
                    <form id="wdes-form-plugins">
                        <?php if( ! empty($template_vars['plugins']['require']) ): ?>
                            <!-- Block -->
                            <div class="wdes-panel-plugins-list-block">
                                <h5 class="wdes-panel-plugins-list-block_title"><?php esc_html_e( 'Required Plugins', 'phox' ); ?></h5>
                                <ul class="wdes-panel-plugins-list-items">
                                    <!-- Item -->
                                    <?php foreach( $template_vars['plugins']['require'] as $require ): ?>
                                        <li data-id="<?php echo esc_html($require['slug']) ?>" class="wdes-panel-plugins-list-item">
                                            <label class="wdes-panel-plugins-list-item-check">
                                                <input type="checkbox" name="plugins" value="<?php echo esc_html($require['slug']) ?>" checked />
                                                <span class="checkmark"></span>
                                                <span class="wdes-panel-plugins-list-item-content"><?php esc_html_e($require['name'], 'phox') ?> <?php if (! empty( $require['version'] ) ) : ?><small>v<?php echo esc_html($require['version']); ?></small><?php endif; ?></span>
                                            </label>
                                            <div>
                                                <span class="wdes-panel-plugins-list-item-status"><?php esc_html_e( 'Not Installed', 'phox' ); ?></span>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <!-- Block -->
                        <?php if( ! empty($template_vars['plugins']['optional']) ): ?>
                            <div class="wdes-panel-plugins-list-block">
                                <h5 class="wdes-panel-plugins-list-block_title"><?php esc_html_e( 'Optional plugins', 'phox' ); ?></h5>
                                <ul class="wdes-panel-plugins-list-items">
                                    <?php foreach( $template_vars['plugins']['optional'] as $optional ): ?>
                                        <!-- Item -->
                                        <li data-id="<?php echo esc_attr($optional['slug'])?>" class="wdes-panel-plugins-list-item">
                                            <label class="wdes-panel-plugins-list-item-check">
                                                <input type="checkbox" name="plugins" value="<?php echo esc_attr($optional['slug'])?>" checked />
                                                <span class="checkmark"></span>
                                                <span class="wdes-panel-plugins-list-item-content"><?php esc_html_e($optional['name'], 'phox') ?> <?php if (! empty( $optional['version'] ) ) : ?><small>v<?php echo esc_html($optional['version']); ?></small><?php endif; ?></span>
                                            </label>
                                            <div>
                                                <span class="wdes-panel-plugins-list-item-status"><?php esc_html_e( 'Not Installed', 'phox' ); ?></span>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>    
                                </ul>
                            </div>
                        <?php endif; ?>

                        <!-- Submit -->
                        <button id="plugins-form-submit-btn" type="submit" class="wdes-panel-plugins-activate btn btn-primary"><?php esc_html_e('Install Plugins', 'phox'); ?></button>
                    </form>

                    <!-- Success State -->
                    <a class="wdes-panel-plugins-next-step hidden" href="<?php echo esc_url($template_vars['plugins']['next_step_url']); ?>">Next Step</a>

                    <!-- Error Message -->
                    <div class="wdes-error-msg hidden"></div>
                    
                    <!-- Guide -->
                    <div class="wdes-panel-guide">
                        <a target="_blank" href="https://phox.whmcsdes.com/docs/how-to-install-phox-via-ftp/">
                            <?php esc_html_e( 'For assistance check installation article', 'phox' ); ?>
                        </a>
                    </div>
                </div>
            <?php endif; ?>

            <?php if( isset($template_vars['finish']) ): ?>
                <!-- Heading -->
                <div class="wdes-panel-wrapper_heading">
                    <h1><?php esc_html_e( 'You\'re ready to go!', 'phox' ); ?></h1>
                    <p><?php esc_html_e( 'You can import demo content or explore theme features', 'phox' ); ?></p>
                </div>

                <!-- Quick Actions -->
                <div class="wdes-quick-actions">
                    <!-- Import Demo -->
                    <a href="<?php echo $template_vars['finish']['import_url']; ?>">
                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/add-browser.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <span>Import Demo Content</span>
                    </a>

                    <!-- Theme Options -->
                    <a href="<?php echo $template_vars['finish']['ticket_url']; ?>">
                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/settings.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <span>Theme Options</span>
                    </a>

                    <!-- Home -->
                    <a href="<?php echo $template_vars['finish']['dashboard_url']; ?>">
                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/flag.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <span>Open Ticket</span>
                    </a>

                    <!-- Documentation -->
                    <a href="https://phox.whmcsdes.com/docs">
                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/book.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <span>Documentation</span>
                    </a>

                    <!-- Custom Development -->
                    <a href="https://whmcsdes.com/services">
                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/code.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <span>Custom Development</span>
                    </a>

                    <!-- Dashbaord -->
                    <a class="btn-primary wdes-quick-actions_btn-skip" href="<?php echo $template_vars['finish']['theme_option_url']; ?>">
                        <img src="<?php echo esc_url( WDES_ADMIN_ASSETS_URI . '/img/dashboard.svg' ); ?>" alt="<?php esc_attr_e('Phox', 'phox'); ?>">
                        <span>Getting Started</span>
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php endif; ?>