<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\DB_Proxy;

abstract class Abstract_Page
{

    /**
     * Collections
     *
     * Collection of section that build the page
     *
     * @var array $collection
     */
    private array $collection;

    protected array $elements_registration_list;

    /**
     * @param string $page_name Set Page name and this name will show only on his place that have options, not on the menu
     */
    public function __construct(
        string $page_name,
    )
    {
        $this->collection = [];
        $this->collection['title'] = esc_html__($page_name, 'phox');
        $this->collection['sections'] = [];
    }

    /**
     * Build Pages
     *
     * All sections and options that create pages options
     *
     * @since 2.3.6
     * @return void
     */
    abstract public function build_pages(): void;

    /**
     * Registers elements from the elements registration list to the provided section.
     *
     * This method performs two main actions:
     * 1. It loops over the elements in the property `elements_registration_list` and
     *    calls the `add_element` method on the provided `$section` object for each element.
     * 2. It add the `elements_registration_list` property after processing all elements.
     *
     * @param Sections $section The section to which the elements will be registered.
     * @param array $elements The list of elements
     * @return void
     */
    private function register_elements(Sections $section, array $elements)
    {

        foreach ($elements as $element) {
            $section->add_element($element);
            $this->elements_registration_list[] = $element;
        }

    }

    /**
     * Add Section On Collection
     *
     * @param Sections $section Section item
     * @param array $elements
     * @return void
     * @since 2.3.6
     */
    public function add_section_collection(Sections $section, array $elements) : void
    {
        $this->register_elements($section, $elements);
        $this->collection ['sections'][] = $section->get_elements();
    }

    /**
     * Render json
     *
     * Get page section collection and encode the array to json
     *
     * @since 2.3.6
     * @return string
     */
    public function render(): array
    {
        return $this->collection;
    }

    public function before_saving():array
    {
        return [
            'result' => true,
            'errors' => [],
        ];
    }

    public function save()
    {
        $data = [];
        $error = [];
        foreach ($this->elements_registration_list as $element) {

            if (isset($element->get_prepared_save_values()['error'])){

                $error = array_merge($error, $element->get_prepared_save_values()['error']);

            }else{

                $data[$element->get_id()] = $element->get_prepared_save_values();

            }

        }
        if (! empty($error)) {

            return $error;

        }

        $before_save = $this->before_saving();

        if(!$before_save['result']) {
            return $before_save['error'];
        }

        //get data from db & margin it
        $saved_data = get_option(DB_Proxy::PANEL_COLUMN_NAME, []);

        $options  = array_merge($saved_data, $data);

        //save data
        update_option(DB_Proxy::PANEL_COLUMN_NAME, $options);

        return [];

    }

    public function import($imported_data)
    {

        $data = [];
        $error = [];
        foreach ($this->elements_registration_list as $element) {

            if (isset($element->get_prepared_save_values()['error'])){

                $error = array_merge($error, $element->get_prepared_save_values()['error']);

            }else{

                $data[$element->get_id()] = $element->get_prepared_save_values();

            }

        }

        if (! empty($error)) {

            return ['error' => $error];

        }

        return array_merge($imported_data, $data);

    }

}