<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Media;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;

class Page_Custom_Fonts extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_custom_font();
        $this->create_custom_font_two();
    }

    private function create_custom_font(): void
    {
        $section_custom_font = new Sections(
            section_name: esc_html__('Font 1', 'phox'),
            description: '',
            doc_link: 'typography-options/#headingsTypo'
        );

        $text_fonts = new Text(
            id:'font-custom',
            value: '',
            title: esc_html__('Name','phox'),
            description: esc_html__('Please use only letters or spaces, eg. Custom Font 1', 'phox'),
        ) ;

        $media_fonts_woff2 = new Media(
            id:'font-custom-woff2',
            value: '',
            title: esc_html__('WOFF2','phox'),
            description: esc_html__('Here you can upload your font with .woff2 extension', 'phox')
        );
        $media_fonts_woff2->media_type('font');

        $media_fonts_woff = new Media(
            id:'font-custom-woff',
            value: '',
            title: esc_html__('WOFF','phox'),
            description: esc_html__('Here you can upload your font with .woff extension.', 'phox')
        );
        $media_fonts_woff->media_type('font');

        $media_fonts_ttf = new Media(
            id:'font-custom-ttf',
            value: '',
            title: esc_html__('TTF','phox'),
            description: esc_html__('Here you can upload your font with .ttf extension.', 'phox')
        );
        $media_fonts_ttf->media_type('font');


        $media_fonts_otf = new Media(
            id:'font-custom-otf',
            value: '',
            title: esc_html__('OTF','phox'),
            description: esc_html__('Here you can upload your font with .otf extension.', 'phox')
        );
        $media_fonts_otf->media_type('font');

        $media_fonts_svg = new Media(
            id:'font-custom-svg',
            value: '',
            title: esc_html__('SVG','phox'),
            description: esc_html__('Here you can upload your font with .svg extension.', 'phox')
        );
        $media_fonts_svg->media_type('font');

        $this->add_section_collection($section_custom_font, [
            $text_fonts,
            $media_fonts_woff2,
            $media_fonts_woff,
            $media_fonts_ttf,
            $media_fonts_otf,
            $media_fonts_svg
        ]);
    }

    private function create_custom_font_two(): void
    {
        $section_custom_font = new Sections(
            section_name: esc_html__('Font 2', 'phox'),
            description: '',
            doc_link: 'typography-options/#headingsTypo'
        );

        $text_fonts = new Text(
            id:'font-custom-2',
            value: '',
            title: esc_html__('Name','phox'),
            description: esc_html__('Please use only letters or spaces, eg. Custom Font 2', 'phox'),
        ) ;

        $media_fonts_woff2 = new Media(
            id:'font-custom-2-woff2',
            value: '',
            title: esc_html__('WOFF2','phox'),
            description: esc_html__('Here you can upload your font with .woff2 extension.', 'phox')
        );
        $media_fonts_woff2->media_type('font');

        $media_fonts_woff = new Media(
            id:'font-custom-2-woff',
            value: '',
            title: esc_html__('WOFF','phox'),
            description: esc_html__('Here you can upload your font with .woff extension.', 'phox')
        );
        $media_fonts_woff->media_type('font');

        $media_fonts_ttf = new Media(
            id:'font-custom-2-ttf',
            value: '',
            title: esc_html__('TTF','phox'),
            description: esc_html__('Here you can upload your font with .ttf extension.', 'phox')
        );
        $media_fonts_ttf->media_type('font');


        $media_fonts_otf = new Media(
            id:'font-custom-2-otf',
            value: '',
            title: esc_html__('OTF','phox'),
            description: esc_html__('Here you can upload your font with .otf extension.', 'phox')
        );
        $media_fonts_otf->media_type('font');

        $media_fonts_svg = new Media(
            id:'font-custom-2-svg',
            value: '',
            title: esc_html__('SVG','phox'),
            description: esc_html__('Here you can upload your font with .svg extension.', 'phox')
        );
        $media_fonts_svg->media_type('font');

        $this->add_section_collection($section_custom_font, [
            $text_fonts,
            $media_fonts_woff2,
            $media_fonts_woff,
            $media_fonts_ttf,
            $media_fonts_otf,
            $media_fonts_svg
        ]);
    }
}