<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\actions\Export_Admin_Options;
use Phox\core\admin\panel\wdes_options\pages\elements\actions\Import_Admin_Options;
use Phox\core\admin\panel\wdes_options\pages\elements\actions\Reset_Admin_Options;
use Phox\core\admin\panel\wdes_options\pages\elements\Button;
use Phox\core\admin\panel\wdes_options\pages\elements\TextArea;
use Phox\core\admin\panel\wdes_options\pages\Sections;

class Page_Import_Export extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
       $this->create_import_section();
       $this->create_export_section();
       $this->create_reset_section();
    }

    private function create_import_section():void
    {

        $section_import = new Sections(
            section_name: esc_html__('Import', 'phox'),
            description: '',
            doc_link: 'import-export-reset-options'
        );

        $textarea_import = new TextArea(
            id: 'import_code',
            value: '',
            title: esc_html__('Content', 'phox'),
            description: esc_html__('Copy the contents of the json file and paste it below. Then click Import to restore your setings.', 'phox')
        );

        $button_import = new Button(
            id:'import',
            action: 'import_admin_options',
            action_class: new Import_Admin_Options,
            title: esc_attr__('Import', 'phox'),
            description: 'WARNING! This will overwrite all existing options, please proceed with caution!',
        );

        $this->add_section_collection($section_import, [
            $textarea_import,
            $button_import
        ]);

    }

    private function create_export_section():void
    {
        $section_export = new Sections(
            section_name: esc_html__('Export', 'phox'),
            description: '',
            doc_link: 'import-export-reset-options'
        );

        $button_export = new Button(
            id: 'export',
            action: 'export_admin_options',
            action_class: new Export_Admin_Options,
            title: esc_html__('Export Options', 'phox'),
            description: esc_html__('Here you can download your current options settings. Keep this safe as you can use it as a backup should anything go wrong, or you can use it to restore your settings on this site (or any other site).','phox')
        );

        $this->add_section_collection($section_export, [
            $button_export
        ]);
    }

    private function create_reset_section():void
    {

        $section_reset = new Sections(
            section_name: esc_html__('Reset', 'phox'),
            description: '',
            doc_link: ''
        );

        $button_reset = new Button(
            id: 'reset',
            action: 'reset_admin_options',
            action_class: new Reset_Admin_Options,
            title: esc_html__('Reset Settings', 'phox'),
            description: esc_html__('WARNING! This will overwrite all existing options, please proceed with caution!', 'phox')
        );

        $this->add_section_collection($section_reset, [
            $button_reset
        ]);

    }
}