<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Editor;
use Phox\core\admin\panel\wdes_options\pages\elements\Text;
use Phox\core\admin\panel\wdes_options\pages\elements\TextArea;

class Page_JS_CSS extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_css_section();
        $this->create_js_section();
    }

    private function create_css_section()
    {
        $section_css = new Sections(
            section_name: esc_html__('Custom CSS', 'phox'),
            description: '',
            doc_link: 'custom-style-script-options'
        );

        $text_css = new Editor(
            id:'custom-css',
            value: '',
            title: esc_html__('CSS Code','phox'),
            description: esc_html__('Enter your CSS code in the field below. Do not include any tags or HTML in the field. Custom CSS entered here will override the theme CSS. In some cases, the !important tag may be needed.', 'phox')
        );

        $this->add_section_collection($section_css,[
            $text_css
        ]);
    }

    private function create_js_section()
    {
        $section_js = new Sections(
            section_name: esc_html__('Custom Script', 'phox'),
            description: '',
            doc_link: ''
        );

        $text_js = new Editor(
            id:'custom-js',
            value: '',
            title: esc_html__('JS Code','phox'),
            description: esc_html__('Enter your JS code in the field below.', 'phox'),
        );

        $this->add_section_collection($section_js,[
            $text_js
        ]);
    }
}