<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Media;
use Phox\core\admin\panel\wdes_options\pages\elements\Radio;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;

class Page_Miscellaneous extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_loading_screen_section();
    }

    private function create_loading_screen_section()
    {
        $section_loading_screen = new Sections(
            section_name: esc_html__('Loading Screen','phox'),
            description: '',
            doc_link: 'general-settings-options/#docs-general-layout'
        );

        $toggle_display_screen = new Toggle(
            id:'preloader',
            value: false,
            title: esc_html__('Display Loading Screen','phox'),
            description: esc_html__('Turn on to display the loading screen.', 'phox')
        );

        $radio_preloader_type = new Radio(
            id:'preloader_type',
            value: 'two-circle',
            title: esc_html__('Preloader type','phox'),
            description: esc_html__('Choose loading image for website preloader.', 'phox'),
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Two Circle Spinner','phox'),
            value: 'two-circle',
            thumb: 'image_preloader1'
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Classic spinner','phox'),
            value: 'classic-spinner',
            thumb: 'image_preloader2'
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Double bounce','phox'),
            value: 'double-bounce',
            thumb: 'image_preloader3'
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Circle spinner','phox'),
            value: 'circle-spinner',
            thumb: 'image_preloader4'
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Waves','phox'),
            value: 'waves',
            thumb: 'image_preloader5'
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Folding cube','phox'),
            value: 'folding-cube',
            thumb: 'image_preloader6'
        );

        $radio_preloader_type->set_option(
            label: esc_html__('Custom','phox'),
            value: 'custom',
            thumb: 'image_custom'
        );

        $media_custom = new Media(
            id: 'preloader_type_custom',
            value: '',
            title: esc_html__('Custom preloader','phox'),
            description: esc_html__('Upload a custom preloader image', 'phox'),
        );

        $this->add_section_collection($section_loading_screen,[
            $toggle_display_screen,
            $radio_preloader_type,
            $media_custom
        ]);
    }
}