<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\elements\Radio;
use Phox\core\admin\panel\wdes_options\pages\elements\Select;

class Page_Sidebar extends Abstract_Page
{

    public function build_pages(): void
    {
        $this->create_section_archive();
        $this->create_section_single();
    }

    private function create_section_archive(): void
    {
       $section_archive = new Sections(
           section_name: esc_html__('Archive', 'phox'),
           description: '',
           doc_link: 'sidebar-options'
       );

       $radio_layout = new Radio(
           id: 'sidebar-page-layout',
           value: 'right',
           title: esc_html__('Layout','phox'),
           description: esc_html__('Choose archive sidebar layout.', 'phox')
       );

        $radio_layout->set_option(
            label: esc_html__('Full', 'phox'),
            value: 'no',
            thumb: 'sidebar-layout-full',
        );

        $radio_layout->set_option(
            label: esc_html__('Left', 'phox'),
            value: 'left',
            thumb: 'sidebar-layout-left',
        );

        $radio_layout->set_option(
            label: esc_html__('Right', 'phox'),
            value: 'right',
            thumb: 'sidebar-layout-right'
        );

        $select_sidebar = new Select(
            id: 'sidebar-page-sidebar-one',
            value: 'main',
            title: esc_html__('Sidebar','phox'),
            description: esc_html__('Choose active sidebar.', 'phox')
        );

        $select_sidebar->set_option(
            label: esc_html__('Main Sidebar', 'phox'),
            value: 'main'
        );

        $select_sidebar->set_option(
            label: esc_html__('Left Sidebar', 'phox'),
            value: 'left'
        );

        $select_sidebar->set_option(
            label: esc_html__('Right Sidebar', 'phox'),
            value: 'right'
        );

        $this->add_section_collection($section_archive,[
            $radio_layout,
            $select_sidebar,
        ]);
    }

    private function create_section_single()
    {
        $section_single = new Sections(
            section_name: esc_html__('Single', 'phox'),
            description: '',
            doc_link: 'sidebar-options'
        );

        $radio_layout = new Radio(
            id: 'sidebar-single-layout',
            value: 'no',
            title: esc_html__('Layout','phox'),
            description: esc_html__('Choose single sidebar layout.', 'phox')
        );

        $radio_layout->set_option(
            label: 'Full',
            value: 'no',
            thumb: 'sidebar-layout-full'
        );

        $radio_layout->set_option(
            label: 'Left',
            value: 'left',
            thumb: 'sidebar-layout-left'
        );

        $radio_layout->set_option(
            label: 'Right',
            value: 'right',
            thumb: 'sidebar-layout-right'
        );

        $select_sidebar = new Select(
            id: 'sidebar-single-sidebar-one',
            value: 'main',
            title: esc_html__('Sidebar','phox'),
            description: esc_html__('Use this option when use one sidebar option', 'phox')
        );

        $select_sidebar->set_option(
            label: 'Main Sidebar',
            value: 'main'
        );

        $select_sidebar->set_option(
            label: 'Left Sidebar',
            value: 'left'
        );

        $select_sidebar->set_option(
            label: 'Right Sidebar',
            value: 'right'
        );

        $this->add_section_collection($section_single,[
            $radio_layout,
            $select_sidebar,
        ]);

    }
}