<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;

class Page_Single extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_general_section();
    }

    private function create_general_section(): void
    {
        $section_general = new Sections(
            section_name: esc_html__('General', 'phox'),
            description: '',
            doc_link: 'pages-options/#singleOptions'
        );

        $toggle_sidebar = new Toggle(
            id: 'single-post-sidebars',
            value: false,
            title: esc_html__('Hide Sidebar ', 'phox'),
            description: esc_html__('Turn on to hide the sidebar.', 'phox')
        );

        $toggle_time = new Toggle(
            id: 'single-post-time',
            value: false,
            title: esc_html__('Hide Date', 'phox'),
            description: esc_html__('Turn on to hide the date.', 'phox')
        );

        $toggle_author = new Toggle(
            id: 'single-post-author',
            value: false,
            title: esc_html__('Hide Author Box ', 'phox'),
            description: esc_html__('Turn on to hide the author box.', 'phox')
        );

        $toggle_image = new Toggle(
            id: 'single-post-image',
            value: false,
            title: esc_html__('Hide Featured Image ', 'phox'),
            description: esc_html__('Turn on to hide the featured image.', 'phox')
        );

        $toggle_category = new Toggle(
            id: 'single-post-category',
            value: false,
            title: esc_html__('Hide Category ', 'phox'),
            description: esc_html__('Turn on to hide the category.', 'phox')
        );

        $toggle_tag = new Toggle(
            id: 'single-post-tag',
            value: false,
            title: esc_html__('Hide Tags ', 'phox'),
            description: esc_html__('Turn on to hide the tags.', 'phox')
        );

        $toggle_comments = new Toggle(
            id: 'single-post-comments',
            value: false,
            title: esc_html__('Hide Comments', 'phox'),
            description: esc_html__('Turn on to hide the comments.', 'phox')
        );

        $toggle_social_share = new Toggle(
            id: 'single-socailshare',
            value: false,
            title: esc_html__('Hide Social Media Share Links', 'phox'),
            description: esc_html__('Turn on to hide the social media share links.', 'phox')
        );

        $this->add_section_collection($section_general, [
            $toggle_sidebar,
            $toggle_time,
            $toggle_author,
            $toggle_image,
            $toggle_category,
            $toggle_tag,
            $toggle_comments,
            $toggle_social_share,
        ]);
    }
}