<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Color;
use Phox\core\admin\panel\wdes_options\pages\elements\Radio;
use Phox\core\admin\panel\wdes_options\pages\elements\Select;
use Phox\core\admin\panel\wdes_options\pages\elements\Toggle;

class Page_ToTop extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_totop_section();
        $this->create_footer_button_section();
    }

    private function create_totop_section()
    {
        $section_totop = new Sections(
            section_name: esc_html__('Back To Top Button', 'phox'),
            description: '',
            doc_link: 'footer-options'
        );

        $toggle_display = new Toggle(
            id: 'backto-btn-display',
            value: false,
            title: esc_html__('Display Button','phox'),
            description: esc_html__('Enable it to display the back to top button.', 'phox')
        );

        $select_position = new Radio(
            id: 'backto-btn-position',
            value: 'right',
            title: esc_html__('Button Position','phox'),
            description: esc_html__('Specifies the position of back to top button.', 'phox')
        );

        $select_position->set_option(
            label: esc_attr('Right', 'phox'),
            value: 'right',
            thumb: 'extras-back-to-top-right'
        );

        $select_position->set_option(
            label: esc_attr('Center', 'phox'),
            value: 'center',
            thumb: 'extras-back-to-top-Center'
        );

        $select_position->set_option(
            label: esc_attr('Left', 'phox'),
            value: 'left',
            thumb: 'extras-back-to-top-left'
        );

        $this->add_section_collection($section_totop,[
            $toggle_display,
            $select_position
        ]);
    }

    private function create_footer_button_section()
    {
        $section_footer_button = new Sections(
            section_name: esc_html__('Back To Top Button', 'phox'),
            description: '',
            doc_link: 'color-options/#backtotop'
        );

        $color_blog_footer_backtotop_bg = new Color(
            id: 'color-footer-backtotop-bg',
            value: '#274961',
            title: esc_html__('Button Background Color','phox'),
            description: 'Set the color of the button background.'
        );

        $color_blog_footer_backtotop_bg_hvr = new Color(
            id: 'color-footer-backtotop-bg-hvr',
            value: '#CC2241',
            title: esc_html__('Button Hover Background Color','phox'),
            description: 'Set the color of the button background when hovered.'
        );

        $color_blog_footer_backtotop_border = new Color(
            id: 'color-footer-backtotop-border',
            value: '#274961',
            title: esc_html__('Button Hover Background Color','phox'),
            description: 'Set the color of the button background when hovered.'
        );

        $color_blog_footer_backtotop_border_hvr = new Color(
            id: 'color-footer-backtotop-border-hvr',
            value: '#CC2241',
            title: esc_html__('Button Hover Border Color','phox'),
            description: 'Set the color of the button border when hovered.'
        );

        $color_blog_footer_backtotop_icon_clr = new Color(
            id: 'color-footer-backtotop-icon-clr',
            value: '#ffffff',
            title: esc_html__('Button Icon Color','phox'),
            description: 'Set the color of the button icon.'
        );

        $this->add_section_collection($section_footer_button,[
            $color_blog_footer_backtotop_bg,
            $color_blog_footer_backtotop_bg_hvr,
            $color_blog_footer_backtotop_border,
            $color_blog_footer_backtotop_border_hvr,
            $color_blog_footer_backtotop_icon_clr
        ]);
    }
}