<?php

namespace Phox\core\admin\panel\wdes_options\pages;

use Phox\core\admin\panel\wdes_options\pages\Abstract_Page;
use Phox\core\admin\panel\wdes_options\pages\elements\Typo;

class Page_Typography extends Abstract_Page
{

    /**
     * @inheritDoc
     */
    public function build_pages(): void
    {
        $this->create_general_section();
        $this->create_submenu_section();
        $this->create_mega_section();
        $this->create_blog_section();
        $this->create_body_section();
        $this->create_heading_section();
    }

    private function create_general_section(): void
    {
        $section_general = new Sections(
            section_name: esc_html__('Menu', 'phox'),
            description: '',
            doc_link: 'typography-options/#menuTypo'
        );

        $typo_main_menu = new Typo(
            id: 'typography-main-menu',
            font: 'Montserrat',
            size: 14,
            weight: 600,
            title: esc_html__('Link', 'phox'),
            description: esc_html__('These settings control the typography for menu links.', 'phox')
        );

        $this->add_section_collection($section_general,[
            $typo_main_menu
        ]);
    }

    private function create_submenu_section(): void
    {

        $section_submenu = new Sections(
            section_name: esc_html__('Sub Menu', 'phox'),
            description: '',
            doc_link: 'typography-options/#subMenuTypo'
        );

        $typo_sub_menu = new Typo(
            id: 'typography-sub-menu',
            font: 'Montserrat',
            size: 13,
            weight: 400,
            title: esc_html__('Link', 'phox'),
            description: esc_html__('These settings control the typography for sub menu links.', 'phox')
        );

        $this->add_section_collection($section_submenu,[
            $typo_sub_menu
        ]);

    }

    private function create_mega_section(): void
    {
        $section_mega = new Sections(
          section_name: esc_html__('Mega Menu Typography', 'phox'),
          description: '',
          doc_link: 'typography-options/#megaMenuTypo'
        );

        $typo_mega_menu = new Typo(
            id: 'typography-mega-menu',
            font: 'Montserrat',
            size: 16,
            weight: 600,
            title: esc_html__('Heading','phox'),
            description: esc_html__('These settings control the typography for mega menu headings', 'phox')
        );

        $this->add_section_collection($section_mega,[
            $typo_mega_menu
        ]);
    }



    private function create_blog_section(): void
    {
        $section_blog = new Sections(
            section_name: 'Blog',
            description: '',
            doc_link: 'typography-options/#blogTypo'
        );

        $typo_blog_bread_title = new Typo(
            id: 'typo_blog_bread_title',
            font: 'Poppins',
            size: 50,
            weight: 600,
            title: esc_html__('Breadcrumb Title', 'phox'),
            description: esc_html__('These settings control the typography for breadcrumb title.', 'phox')
        );

        $typo_blog_post_title = new Typo(
            id: 'typography-blog-t',
            font: 'Poppins',
            size: 18,
            weight: 700,
            title: esc_html__('Post Title In Blog Page', 'phox'),
            description: esc_html__('These settings control the typography for post title.', 'phox')
        );

        $typo_blog_post_title_single = new Typo(
            id: 'typography-blog-t-s',
            font: 'Poppins',
            size: 36,
            weight: 600,
            title: esc_html__('Post Title In Single Page', 'phox'),
            description: esc_html__('These settings control the typography for post title.', 'phox')
        );

        $this->add_section_collection($section_blog,[
            $typo_blog_bread_title,
            $typo_blog_post_title,
            $typo_blog_post_title_single
        ]);
    }

    private function create_body_section(): void
    {
        $section_body = new Sections(
            section_name: 'Body',
            description: '',
            doc_link: 'typography-options/#bodyTypo'
        );

        $typo_paragraph = new Typo(
            id: 'typography-body-p',
            font: 'Roboto',
            size: 14,
            weight: 400,
            title: esc_html__('Paragraph', 'phox'),
            description: esc_html__('These settings control the typography for all paragraphs.', 'phox')
        );

        $typo_blockquote = new Typo(
            id: 'typography-body-blockquote',
            font: 'Roboto',
            size: 16,
            weight: 600,
            title: esc_html__('Blockquote', 'phox'),
            description: esc_html__('These settings control the typography for all blockquotes.', 'phox')
        );

        $typo_links = new Typo(
            id: 'typography-body-links',
            font: 'Roboto',
            size: 17,
            weight: 400,
            title: esc_html__('Links', 'phox'),
            description: esc_html__('These settings control the typography for all links.', 'phox')
        );

        $this->add_section_collection($section_body,[
            $typo_paragraph,
            $typo_blockquote,
            $typo_links
        ]);
    }

    private function create_heading_section(): void
    {
        $section_heading = new Sections(
            section_name: esc_html__('Headings Typography', 'phox'),
            description: '',
            doc_link: 'typography-options/#headingsTypo'
        );

        $typo_h1 = new Typo(
            id: 'heading-h1',
            font: 'Poppins',
            size: 32,
            weight: 700,
            title: esc_html__('H1', 'phox'),
            description: esc_html__('These settings control the typography for all H1 headings.', 'phox')
        );

        $typo_h2 = new Typo(
            id: 'heading-h2',
            font: 'Poppins',
            size: 24,
            weight: 700,
            title: esc_html__('H2', 'phox'),
            description: esc_html__('These settings control the typography for all H2 headings.', 'phox')
        );

        $typo_h3 = new Typo(
            id: 'heading-h3',
            font: 'Poppins',
            size: 20.8,
            weight: 700,
            title: esc_html__('H3', 'phox'),
            description: esc_html__('These settings control the typography for all H3 headings.', 'phox')
        );

        $typo_h4 = new Typo(
            id: 'heading-h4',
            font: 'Poppins',
            size: 16,
            weight: 700,
            title: esc_html__('H4', 'phox'),
            description: esc_html__('These settings control the typography for all H4 headings.', 'phox')
        );

        $typo_h5 = new Typo(
            id: 'heading-h5',
            font: 'Poppins',
            size: 12.8,
            weight: 700,
            title: esc_html__('H5', 'phox'),
            description: esc_html__('These settings control the typography for all H5 headings.', 'phox')
        );

        $typo_h6 = new Typo(
            id: 'heading-h6',
            font: 'Poppins',
            size: 11.2,
            weight: 700,
            title: esc_html__('H6', 'phox'),
            description: esc_html__('These settings control the typography for all H6 headings.', 'phox')
        );

        $this->add_section_collection($section_heading,[
            $typo_h1,
            $typo_h2,
            $typo_h3,
            $typo_h4,
            $typo_h5,
            $typo_h6
        ]);

    }
}