<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements\actions;

if ( ! defined( 'ABSPATH' ) ) {
    exit; //Exit if assessed directly
}

/**
 * Abstract class Abstract_Action
 *
 * This class serves as a base for other classes that need to implement
 * an action through the call method and provide utility for preparing
 * button action messages.
 *
 * Constants:
 * WHMCS_FETCH_DATA_OPTION_NAME - Name of the option to fetch data from WHMCS.
 */
abstract class Abstract_Action
{
    const WHMCS_FETCH_DATA_OPTION_NAME = 'wdes_whmcs_fetch_data';

    abstract public function call();

    /**
     * Prepares a message for output by escaping HTML characters.
     *
     * @param string $message The message to be escaped.
     * @return string The escaped message.
     */
    public function button_action_prepare_message($message){

        return esc_html__($message, 'phox');

    }
}