<?php
namespace Phox\core\admin\panel\wdes_options\pages\elements\actions;

if ( ! defined( 'ABSPATH' ) ) {
    exit; //Exit if assessed directly
}

use Phox\core\admin\panel\wdes_options\pages\elements\actions\Abstract_Action;
use Phox\core\admin\panel\wdes_options\Panel_Controller;

/**
 * A class that handles the export of admin options.
 */
class Export_Admin_Options extends Abstract_Action
{

    /**
     * Executes the export process by invoking the export_process method of the Panel_Controller instance.
     *
     */
    public function export_admin_options()
    {
        Panel_Controller::getInstance()->export_process();
    }

    /**
     * Triggers the export method of the current instance.
     *
     * @return void
     */
    public function call():void
    {
        $this->export_admin_options();
    }
}