<?php
namespace Phox\core\admin\panel\wdes_options\pages\elements\actions;

if ( ! defined( 'ABSPATH' ) ) {
    exit; //Exit if assessed directly
}

use Phox\core\admin\panel\wdes_options\pages\elements\actions\Abstract_Action;
use Phox\core\admin\panel\wdes_options\Panel_Controller;

/**
 * The Reset_Admin_Options class provides functionality for resetting administrative options.
 * It extends the Abstract_Action class.
 */
class Reset_Admin_Options extends Abstract_Action
{

    /**
     * Resets the process in the Panel_Controller instance.
     *
     * @return void
     */
    public function reset_admin_options():void
    {
        Panel_Controller::getInstance()->reset_process();
    }

    /**
     * Initiates a call by resetting the current process.
     *
     * @return void
     */
    public function call():void
    {
        $this->reset_admin_options();
    }
}