<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\Elements_Interface;
use Phox\core\admin\panel\wdes_options\Panel_Controller;

class Abstract_Basic_Type implements Elements_Interface
{

    /**
     * ID
     *
     * @since 2.3.6
     * @access protected
     * @var string $id $the id attribute & name attribute for the text input
     */
    protected string $id;

    /**
     * Title
     *
     * @since 2.3.6
     * @access protected
     * @var string $title The name of the element and it should summarise the option what will do
     */
    protected string $title;

    /**
     * Description
     *
     * @since 2.3.6
     * @access protected
     * @var string $description Describe the element and that must have a good information for user
     */
    protected string $description;

    /**
     * Value
     *
     * @since 2.3.6
     * @access protected
     * @var array $values The value of element that come from database.
     */
    protected array $values;

    /**
     * Properties
     *
     * @since 2.3.6
     * @access protected
     * @var array $properties  it has full values to create Text element
     */
    protected array $properties;

    public function default(): void
    {
        $default_values = [
            'id' => $this->type().'-id',
            'title' => ucfirst($this->type()),
            'description' => 'Description',
            'type' => $this->type(),
            'default' => [
                'value' => ''
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'default' => $this->values,
        ]);
    }

    public function render(): array
    {
        $this->default();

        $validate_values = $this->validate_values();

        if( ! $validate_values->check_status() ) {

            $this->properties = array_merge($this->properties, [
                'default' => [],
                'type' => 'error',
                'error' => $validate_values->get_validator()
            ]);

        };

        return $this->properties;
    }

    public function type(): string
    {
        return '';
    }

    public function id(string $id): void
    {
        $this->id = $id;
    }

    public function get_id(): string
    {
        return $this->id;
    }

    public function label(string $label): void
    {
        $this->title = $label;
    }

    public function description(string $description): void
    {
        $this->description = $description;
    }

    public function value($value): void
    {
        $value = ! empty( $this->saved_value() ) ? $this->saved_value() : $value;

        $this->values = [
            'value' => $value
        ];
    }

    public function get_prepared_save_values()
    {
        $values = $this->values['value'];

        $validate_values = $this->validate_values();

        if( ! $validate_values->check_status() ) {

            $values = [
                'error' => $validate_values->get_validator()
            ];

        };
        return $values;
    }

    public function saved_value():mixed
    {

        return Panel_Controller::getInstance()->get_db_source()->get_option($this->id);

    }

    public function validate_type(): string
    {
       return 'string';
    }

    public function validate_values():Element_Validator
    {
        $validator = Element_Validator::getInstance();

        $message = sprintf('The value %s is not a valid %s.', $this->values['value'], $this->type());

        $validator->validate($this->validate_type(),$this->values['value'], $this->id ,$message);

        return $validator;

    }
}