<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\Elements_Interface;

class Abstract_Options_Type extends Abstract_Basic_Type implements Elements_Interface
{
    /**
     * @var array $options List of options
     */
    protected array $options;

    public function default(): void
    {
        $default_values = [
            'id' => $this->type().'-id',
            'title' => ucfirst($this->type()),
            'description' => 'Description',
            'type' => $this->type(),
            'options' =>[],
            'default' => [
                'value' => '',
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'options' => $this->options,
            'default' => $this->values,
        ]);
    }

    public function validate_type(): string
    {
        return 'options';
    }

    public function validate_values():Element_Validator
    {
        $validator = Element_Validator::getInstance();

        $message = sprintf('The value %s is not a valid %s.', $this->values['value'], $this->type());

        $options = [
            'chosen' => $this->values['value'],
            'choices' => $this->options
        ];

        $validator->validate($this->validate_type(),$options, $this->id ,$message);

        return $validator;

    }

    /**
     * Set Option
     *
     * Set new item in options for select element
     *
     * @param string $label This attribute is text for the label indicating the meaning of the option.
     * @param string $value The content of this attribute represents the value to be submitted with the form
     * @param string $thumb
     * @return void
     */
    public function set_option(string $label, string $value, string $thumb = ''): void
    {
        $this->options[]= [
            'value' =>  esc_html__(strtolower($value), 'phox'),
            'label' => ucfirst($label),
            'thumb' => strtolower($thumb),
        ];
    }

}