<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\elements\Abstract_Options_Type;

abstract class Abstract_Select_Element extends Abstract_Options_Type
{
    public function default(): void
    {
        $default_values = [
            'id' => $this->type().'-id',
            'title' => ucfirst($this->type()),
            'description' => 'Description',
            'type' => $this->type(),
            'selectType' => $this->select_type(),
            'options' =>[],
            'default' => [
                'value' => '',
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'options' => $this->options,
            'default' => $this->values,
        ]);
    }

    abstract public function select_type(): string;

    public function type(): string
    {
        return 'select';
    }
}