<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\elements\Abstract_Basic_Type;
use Phox\core\admin\panel\wdes_options\Panel_Controller;

class Editor extends Abstract_Basic_Type
{
    /**
     * @param string $id Set ID
     * @param string $value Set value
     * @param string|null $title Set name
     * @param string|null $description Set description
     */
    public function __construct(
        string $id ,
        string $value,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->value($value);
        $this->properties = [];
    }

    public function saved_value():mixed
    {
        $options = Panel_Controller::getInstance()->get_db_source()->get_option($this->id);

        if(is_string($options)){
            $pre_save_value = stripslashes($options);
        }else{
            $pre_save_value = $options;
        }

        return $pre_save_value;

    }

    public function value($value): void
    {
        $value = ! empty( $this->saved_value() ) ? $this->saved_value() : $value;

        $this->values = [
            'value' => $value
        ];
    }

    public function type(): string
    {
        return 'editor';
    }
}