<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\Elements_Interface;

class Media extends Abstract_Basic_Type
{

    private string $media_type = 'image';

    /**
     * @param string $id Set ID
     * @param string $value Set value
     * @param string|null $title Set name
     * @param string|null $description Set description
     */
    public function __construct(
        string $id ,
        string $value,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->value($value);
        $this->properties = [];
    }

    public function default(): void
    {
        $default_values = [
            'id' => $this->type().'-id',
            'title' => ucfirst($this->type()),
            'description' => 'Description',
            'type' => $this->type(),
            'mediaType' => $this->media_type,
            'default' => [
                'value' => ''
            ],
        ];

        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'default' => $this->values,
        ]);
    }

    public function type(): string
    {
        return 'media';
    }

    /**
     * Set color type key
     *
     * @since 2.3.6
     * @return string
     */
    public function media_type(string $type): void
    {
        $this->media_type = $type;
    }

    public function validate_type(): string
    {
        return $this->media_type;
    }

}