<?php

namespace Phox\core\admin\panel\wdes_options\pages\elements;

use Phox\core\admin\panel\wdes_options\pages\Elements_Interface;
use Phox\core\admin\panel\wdes_options\Panel_Controller;

class Number extends Abstract_Basic_Type
{
    /**
     * @param string $id Set ID
     * @param string $value Set value
     * @param string|null $title Set name
     * @param string|null $description Set description
     */
    public function __construct(
        string $id ,
        $value,
        string $title = null,
        string $description = null,
    )
    {
        $this->label($title);
        $this->description($description);
        $this->id($id);
        $this->value($value);
        $this->properties = [];
    }

    public function default(): void
    {
        $default_values = [
            'id' => 'number-id',
            'title' => 'Number',
            'description' => 'Description',
            'type' => $this->type(),
            'default' => [
                'value' => 0,
            ],
        ];
        $this->properties = array_merge($default_values, [
            'id' => $this->id,
            'title' => $this->title,
            'description' => $this->description,
            'default' => $this->values,
        ]);
    }

    public function type(): string
    {
        return 'number';
    }

    public function saved_value():mixed
    {

        return (int) Panel_Controller::getInstance()->get_db_source()->get_option($this->id);

    }

    public function validate_type(): string
    {
        return 'int';
    }

}