<?php
!defined('ABSPATH') && exit;

use Phox\core\admin\Dashboard_Menu;
use Phox\core\License_Activation;

$license = new License_Activation();

if( is_admin() ) {

    if(! defined('WDES_ADMIN_PARENT_SLUG') ){
        define( 'WDES_ADMIN_PARENT_SLUG', 'phox' );
    }

    //create phox parent menu
    $dashborad_menu = new Dashboard_Menu(
        parent_slug: WDES_ADMIN_PARENT_SLUG,
        page_title: 'Phox',
        menu_slug: 'phox',
        menu_title: 'Phox',
        capability: 'edit_theme_options'
    );

    $icon =  "data:image/svg+xml;base64,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";
    $position = 2.111111;

    new Phox\core\admin\tgm\Wdes_TGM();

    if( !  function_exists('wdes_enable_theme_wizard') )
    {
        /**
         * Check if theme wizard is enabled
         *
         * @return bool
         */
        function wdes_enable_theme_wizard(): bool
        {
            global $license;

            $is_theme_activated = $license->does_activated();
            $fresh_install = get_transient( 'wdes_fresh_install' ) !== 'fresh' ;

            return $is_theme_activated && $fresh_install;

        }
    }

    if ( wdes_enable_theme_wizard() ) {

        include_once WDES_ADMIN_DIR.'/wdes-dashboard.php';

    }else{

        include_once WDES_ADMIN_DIR.'/wdes-wizard.php';

        /* TGM Plugin */
        $dashborad_menu->remove_TGMPA_OCID_menu();

    }

    //Load Notification
    new Phox\core\admin\Notifications();
}

//Load option panel
require_once WDES_OPTIONS_DIR.'/wdes-panel.php';

//redirect after activated theme
add_action('after_switch_theme', 'wdes_after_switch_theme');

if( ! function_exists('wdes_after_switch_theme') ){

    function wdes_after_switch_theme()
    {

        global $license;

        if( ! $license->does_activated())
            return wp_safe_redirect(admin_url('admin.php?page=phox-wizard'));

        return wp_safe_redirect(admin_url('admin.php?page=phox'));
    }

}

// Handle theme deactivation
add_action('switch_theme', 'wdes_on_theme_deactivation');

if (!function_exists('wdes_on_theme_deactivation')) {

    function wdes_on_theme_deactivation()
    {
        global $license;

        if (isset($license) && method_exists($license, 'unregister_license_on_deactivation')) {
            $license->unregister_license_on_deactivation();
        }

        $plugins_to_deactivate = ['elementor/elementor.php', 'phox-host/phox-host.php', 'revslider/revslider.php', 'one-click-demo-import/one-click-demo-import.php', 'contact-form-7/wp-contact-form-7.php'];
        foreach ($plugins_to_deactivate as $plugin) {
            if (is_plugin_active($plugin)) {
                deactivate_plugins($plugin);
            }
        }
    }

}

