<?php
namespace Phox\core\menu;

use \Elementor\Plugin;

/**
 * Register New Fields In Nav Menu
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

/**
 * Wdes_Menu_Register_Fields
 *
 * Main class for adding custom menu item fields in admin area
 *
 * @since 1.5.0
 */
class Wdes_Menu_Register_Fields {
	/**
     * Instance
     *
	 * @var null
	 */
	protected static $_instance = null;

	/**
     * Instance
     *
	 * @return null|Wdes_Menu_Register_Fields
	 */
	public static function instance()
	{
		if ( is_null( self::$_instance ) )
		{
			self::$_instance = new self;
		}

		return self::$_instance;
	}

	/**
     * Menu items Options
     *
	 * @var array
	 */
	private $menu_item_fileds = [];

	/**
     * All Elementor Templates
     *
	 * @var array
	 */
	private $elementor_templates = [];

	private $data = [];

	/**
	 * Menu_Fields constructor.
	 */
	public function __construct()
	{

	    $this->get_elementor_templates();

	    //add custom fields
        $this->menu_item_fileds = [
	        'mega' => [
		        'label' => esc_html( 'Mega Menu'),
		        'type'  => 'checkbox',
		        'default' => '0'
	        ],
            'mega_type' => [
                'label' => esc_html('Mega Menu Type'),
                'type'  => 'select',
                'options' => [
	                'normal'        => esc_html('Normal Mega Menu'),
	                'with_widget'   => esc_html('Mega Menu With Widget'),
	                'template'   => esc_html('Mega Menu With Template'),
                ],
                'default' => 'normal'
            ],
	        'mega_template' => [
		        'label' => esc_html('Select Elementor Template'),
		        'type'  => 'select',
		        'options' => $this->elementor_templates,
		        'default' => ''
	        ],
	        'col_num' => [
		        'label' => esc_html( 'Mega Menu Number of Columns' ),
		        'type'  => 'select',
                'options' => [
                  1 => 1,
                  2 => 2,
                  3 => 3,
                  4 => 4,
                  5 => 5,
                  6 => 6,
                ],
		        'default' => '2'
	        ],
            'icon' => [
                'label' => esc_html( 'Menu Item Icon' ),
                'type'  => 'icon',
                'default' => '',
                'depth' => [ 'min' => 0, 'max' => 100 ]
            ],
	        'icon_color' => [
		        'label' => esc_html( 'Icon Color' ),
		        'type'  => 'color',
		        'default' => '',
		        'depth' => [ 'min' => 0, 'max' => 100 ]
	        ],
	        'icon_align' => [
		        'label' => esc_html('Icon Alignment'),
		        'type'  => 'select',
		        'options' => [
                    'auto'  => esc_html('Auto'),
                    'left'  => esc_html('Left'),
                    'right'  => esc_html('Right'),
                ],
		        'default' => '',
		        'depth' => [ 'min' => 0, 'max' => 100 ]
	        ],
	        'item_label' =>[
		        'label' => esc_html('Label'),
		        'type'  => 'text',
		        'depth' => [ 'min' => 0, 'max' => 100 ]
	        ],
	        'label_color' => [
		        'label' => esc_html( 'Label Color' ),
		        'type'  => 'color',
		        'default' => '',
		        'depth' => [ 'min' => 0, 'max' => 100 ]
	        ],
	        'label_bg_color' => [
		        'label' => esc_html( 'Label Background Color' ),
		        'type'  => 'color',
		        'default' => '',
		        'depth' => [ 'min' => 0, 'max' => 100 ]
	        ],
            'css_class' =>[
	            'label' => esc_html('Add Custom Class'),
	            'type'  => 'text',
	            'depth' => [ 'min' => 0, 'max' => 100 ]
            ],
	        'sec_text' =>[
		        'label' => esc_html('Secondary Text'),
		        'type'  => 'textarea',
		        'depth' => [ 'min' => 1, 'max' => 100 ]
	        ],
            'mega_widgets' => [
		        'label' => esc_html('Select Mega Menu Sidebar'),
		        'type'  => 'sidebars',
		        'default' => '0',
                'depth' => [ 'min' => 1, 'max' => 1 ]
	        ],
        ];

        //add extra fields to menu item in backend menu editor
        add_filter( 'wp_setup_nav_menu_item', [ $this, 'add_custom_nav_item_fields' ] );
		//Edit Menus Page
		add_filter('wp_edit_nav_menu_walker',  [$this, 'wdes_custom_nav_edit_walker'], 10, 2);
		//The Custom Menu
		add_action('wp_nav_menu_item_custom_fields', [$this, 'wdes_custom_fields'], 10, 5);
		//Save The custom Fields
		add_action('wp_update_nav_menu_item', [$this, 'wdes_custom_save'],10 ,3);
		//register css and js for edit menu page
        add_action( 'admin_menu', [$this, 'enqueue_edit_menu'] );
        //add icon picker template
        add_action( 'admin_footer', array( $this, 'print_icons_template' ), 10 );
	}

	/**
	 * Add custom fields to menu item object
	 */
	public function add_custom_nav_item_fields( $menu_item ){

	    foreach ( $this->menu_item_fileds as $filed_id => $filed_info ){

		    $menu_item->{$filed_id} = get_post_meta( $menu_item->ID, '_menu_item_' . $filed_id, true );

        }

        return $menu_item;

    }

    /**
     * Icons template
     * @since 2.1.7
     */
    public function print_icons_template()
    {
        $screen = get_current_screen();

        if ( 'nav-menus' !== $screen->base ) {
            return;
        }

        $icons_list =[
            '500px' => 'fab fa-500px','accessibleicon' => 'fab fa-accessible-icon','accusoft' => 'fab fa-accusoft','acquisitionsincorporated' => 'fab fa-acquisitions-incorporated','ad' => 'fas fa-ad','addressbook' => 'fas fa-address-book','addressbook' => 'far fa-address-book','addresscard' => 'fas fa-address-card','addresscard' => 'far fa-address-card','adjust' => 'fas fa-adjust','adn' => 'fab fa-adn','adversal' => 'fab fa-adversal','affiliatetheme' => 'fab fa-affiliatetheme','airfreshener' => 'fas fa-air-freshener','algolia' => 'fab fa-algolia','aligncenter' => 'fas fa-align-center','alignjustify' => 'fas fa-align-justify','alignleft' => 'fas fa-align-left','alignright' => 'fas fa-align-right','alipay' => 'fab fa-alipay','allergies' => 'fas fa-allergies','amazon' => 'fab fa-amazon','amazonpay' => 'fab fa-amazon-pay','ambulance' => 'fas fa-ambulance','americansignlanguageinterpreting' => 'fas fa-american-sign-language-interpreting','amilia' => 'fab fa-amilia','anchor' => 'fas fa-anchor','android' => 'fab fa-android','angellist' => 'fab fa-angellist','angledoubledown' => 'fas fa-angle-double-down','angledoubleleft' => 'fas fa-angle-double-left','angledoubleright' => 'fas fa-angle-double-right','angledoubleup' => 'fas fa-angle-double-up','angledown' => 'fas fa-angle-down','angleleft' => 'fas fa-angle-left','angleright' => 'fas fa-angle-right','angleup' => 'fas fa-angle-up','angry' => 'fas fa-angry','angry' => 'far fa-angry','angrycreative' => 'fab fa-angrycreative','angular' => 'fab fa-angular','ankh' => 'fas fa-ankh','appstore' => 'fab fa-app-store','appstoreios' => 'fab fa-app-store-ios','apper' => 'fab fa-apper','apple' => 'fab fa-apple','applealt' => 'fas fa-apple-alt','applepay' => 'fab fa-apple-pay','archive' => 'fas fa-archive','archway' => 'fas fa-archway','arrowaltcircledown' => 'fas fa-arrow-alt-circle-down','arrowaltcircledown' => 'far fa-arrow-alt-circle-down','arrowaltcircleleft' => 'fas fa-arrow-alt-circle-left','arrowaltcircleleft' => 'far fa-arrow-alt-circle-left','arrowaltcircleright' => 'fas fa-arrow-alt-circle-right','arrowaltcircleright' => 'far fa-arrow-alt-circle-right','arrowaltcircleup' => 'fas fa-arrow-alt-circle-up','arrowaltcircleup' => 'far fa-arrow-alt-circle-up','arrowcircledown' => 'fas fa-arrow-circle-down','arrowcircleleft' => 'fas fa-arrow-circle-left','arrowcircleright' => 'fas fa-arrow-circle-right','arrowcircleup' => 'fas fa-arrow-circle-up','arrowdown' => 'fas fa-arrow-down','arrowleft' => 'fas fa-arrow-left','arrowright' => 'fas fa-arrow-right','arrowup' => 'fas fa-arrow-up','arrowsalt' => 'fas fa-arrows-alt','arrowsalth' => 'fas fa-arrows-alt-h','arrowsaltv' => 'fas fa-arrows-alt-v','assistivelisteningsystems' => 'fas fa-assistive-listening-systems','asterisk' => 'fas fa-asterisk','asymmetrik' => 'fab fa-asymmetrik','at' => 'fas fa-at','atlas' => 'fas fa-atlas','atom' => 'fas fa-atom','audible' => 'fab fa-audible','audiodescription' => 'fas fa-audio-description','autoprefixer' => 'fab fa-autoprefixer','avianex' => 'fab fa-avianex','aviato' => 'fab fa-aviato','award' => 'fas fa-award','aws' => 'fab fa-aws','backspace' => 'fas fa-backspace','backward' => 'fas fa-backward','balancescale' => 'fas fa-balance-scale','ban' => 'fas fa-ban','bandaid' => 'fas fa-band-aid','bandcamp' => 'fab fa-bandcamp','barcode' => 'fas fa-barcode','bars' => 'fas fa-bars','baseballball' => 'fas fa-baseball-ball','basketballball' => 'fas fa-basketball-ball','bath' => 'fas fa-bath','batteryempty' => 'fas fa-battery-empty','batteryfull' => 'fas fa-battery-full','batteryhalf' => 'fas fa-battery-half','batteryquarter' => 'fas fa-battery-quarter','batterythreequarters' => 'fas fa-battery-three-quarters','bed' => 'fas fa-bed','beer' => 'fas fa-beer','behance' => 'fab fa-behance','behancesquare' => 'fab fa-behance-square','bell' => 'fas fa-bell','bell' => 'far fa-bell','bellslash' => 'fas fa-bell-slash','bellslash' => 'far fa-bell-slash','beziercurve' => 'fas fa-bezier-curve','bible' => 'fas fa-bible','bicycle' => 'fas fa-bicycle','bimobject' => 'fab fa-bimobject','binoculars' => 'fas fa-binoculars','birthdaycake' => 'fas fa-birthday-cake','bitbucket' => 'fab fa-bitbucket','bitcoin' => 'fab fa-bitcoin','bity' => 'fab fa-bity','blacktie' => 'fab fa-black-tie','blackberry' => 'fab fa-blackberry','blender' => 'fas fa-blender','blenderphone' => 'fas fa-blender-phone','blind' => 'fas fa-blind','blogger' => 'fab fa-blogger','bloggerb' => 'fab fa-blogger-b','bluetooth' => 'fab fa-bluetooth','bluetoothb' => 'fab fa-bluetooth-b','bold' => 'fas fa-bold','bolt' => 'fas fa-bolt','bomb' => 'fas fa-bomb','bone' => 'fas fa-bone','bong' => 'fas fa-bong','book' => 'fas fa-book','bookdead' => 'fas fa-book-dead','bookopen' => 'fas fa-book-open','bookreader' => 'fas fa-book-reader','bookmark' => 'fas fa-bookmark','bookmark' => 'far fa-bookmark','bowlingball' => 'fas fa-bowling-ball','box' => 'fas fa-box','boxopen' => 'fas fa-box-open','boxes' => 'fas fa-boxes','braille' => 'fas fa-braille','brain' => 'fas fa-brain','briefcase' => 'fas fa-briefcase','briefcasemedical' => 'fas fa-briefcase-medical','broadcasttower' => 'fas fa-broadcast-tower','broom' => 'fas fa-broom','brush' => 'fas fa-brush','btc' => 'fab fa-btc','bug' => 'fas fa-bug','building' => 'fas fa-building','building' => 'far fa-building','bullhorn' => 'fas fa-bullhorn','bullseye' => 'fas fa-bullseye','burn' => 'fas fa-burn','buromobelexperte' => 'fab fa-buromobelexperte','bus' => 'fas fa-bus','busalt' => 'fas fa-bus-alt','businesstime' => 'fas fa-business-time','buysellads' => 'fab fa-buysellads','calculator' => 'fas fa-calculator','calendar' => 'fas fa-calendar','calendar' => 'far fa-calendar','calendaralt' => 'fas fa-calendar-alt','calendaralt' => 'far fa-calendar-alt','calendarcheck' => 'fas fa-calendar-check','calendarcheck' => 'far fa-calendar-check','calendarminus' => 'fas fa-calendar-minus','calendarminus' => 'far fa-calendar-minus','calendarplus' => 'fas fa-calendar-plus','calendarplus' => 'far fa-calendar-plus','calendartimes' => 'fas fa-calendar-times','calendartimes' => 'far fa-calendar-times','camera' => 'fas fa-camera','cameraretro' => 'fas fa-camera-retro','campground' => 'fas fa-campground','cannabis' => 'fas fa-cannabis','capsules' => 'fas fa-capsules','car' => 'fas fa-car','caralt' => 'fas fa-car-alt','carbattery' => 'fas fa-car-battery','carcrash' => 'fas fa-car-crash','carside' => 'fas fa-car-side','caretdown' => 'fas fa-caret-down','caretleft' => 'fas fa-caret-left','caretright' => 'fas fa-caret-right','caretsquaredown' => 'fas fa-caret-square-down','caretsquaredown' => 'far fa-caret-square-down','caretsquareleft' => 'fas fa-caret-square-left','caretsquareleft' => 'far fa-caret-square-left','caretsquareright' => 'fas fa-caret-square-right','caretsquareright' => 'far fa-caret-square-right','caretsquareup' => 'fas fa-caret-square-up','caretsquareup' => 'far fa-caret-square-up','caretup' => 'fas fa-caret-up','cartarrowdown' => 'fas fa-cart-arrow-down','cartplus' => 'fas fa-cart-plus','cat' => 'fas fa-cat','ccamazonpay' => 'fab fa-cc-amazon-pay','ccamex' => 'fab fa-cc-amex','ccapplepay' => 'fab fa-cc-apple-pay','ccdinersclub' => 'fab fa-cc-diners-club','ccdiscover' => 'fab fa-cc-discover','ccjcb' => 'fab fa-cc-jcb','ccmastercard' => 'fab fa-cc-mastercard','ccpaypal' => 'fab fa-cc-paypal','ccstripe' => 'fab fa-cc-stripe','ccvisa' => 'fab fa-cc-visa','centercode' => 'fab fa-centercode','certificate' => 'fas fa-certificate','chair' => 'fas fa-chair','chalkboard' => 'fas fa-chalkboard','chalkboardteacher' => 'fas fa-chalkboard-teacher','chargingstation' => 'fas fa-charging-station','chartarea' => 'fas fa-chart-area','chartbar' => 'fas fa-chart-bar','chartbar' => 'far fa-chart-bar','chartline' => 'fas fa-chart-line','chartpie' => 'fas fa-chart-pie','check' => 'fas fa-check','checkcircle' => 'fas fa-check-circle','checkcircle' => 'far fa-check-circle','checkdouble' => 'fas fa-check-double','checksquare' => 'fas fa-check-square','checksquare' => 'far fa-check-square','chess' => 'fas fa-chess','chessbishop' => 'fas fa-chess-bishop','chessboard' => 'fas fa-chess-board','chessking' => 'fas fa-chess-king','chessknight' => 'fas fa-chess-knight','chesspawn' => 'fas fa-chess-pawn','chessqueen' => 'fas fa-chess-queen','chessrook' => 'fas fa-chess-rook','chevroncircledown' => 'fas fa-chevron-circle-down','chevroncircleleft' => 'fas fa-chevron-circle-left','chevroncircleright' => 'fas fa-chevron-circle-right','chevroncircleup' => 'fas fa-chevron-circle-up','chevrondown' => 'fas fa-chevron-down','chevronleft' => 'fas fa-chevron-left','chevronright' => 'fas fa-chevron-right','chevronup' => 'fas fa-chevron-up','child' => 'fas fa-child','chrome' => 'fab fa-chrome','church' => 'fas fa-church','circle' => 'fas fa-circle','circle' => 'far fa-circle','circlenotch' => 'fas fa-circle-notch','city' => 'fas fa-city','clipboard' => 'fas fa-clipboard','clipboard' => 'far fa-clipboard','clipboardcheck' => 'fas fa-clipboard-check','clipboardlist' => 'fas fa-clipboard-list','clock' => 'fas fa-clock','clock' => 'far fa-clock','clone' => 'fas fa-clone','clone' => 'far fa-clone','closedcaptioning' => 'fas fa-closed-captioning','closedcaptioning' => 'far fa-closed-captioning','cloud' => 'fas fa-cloud','clouddownloadalt' => 'fas fa-cloud-download-alt','cloudmeatball' => 'fas fa-cloud-meatball','cloudmoon' => 'fas fa-cloud-moon','cloudmoonrain' => 'fas fa-cloud-moon-rain','cloudrain' => 'fas fa-cloud-rain','cloudshowersheavy' => 'fas fa-cloud-showers-heavy','cloudsun' => 'fas fa-cloud-sun','cloudsunrain' => 'fas fa-cloud-sun-rain','clouduploadalt' => 'fas fa-cloud-upload-alt','cloudscale' => 'fab fa-cloudscale','cloudsmith' => 'fab fa-cloudsmith','cloudversify' => 'fab fa-cloudversify','cocktail' => 'fas fa-cocktail','code' => 'fas fa-code','codebranch' => 'fas fa-code-branch','codepen' => 'fab fa-codepen','codiepie' => 'fab fa-codiepie','coffee' => 'fas fa-coffee','cog' => 'fas fa-cog','cogs' => 'fas fa-cogs','coins' => 'fas fa-coins','columns' => 'fas fa-columns','comment' => 'fas fa-comment','comment' => 'far fa-comment','commentalt' => 'fas fa-comment-alt','commentalt' => 'far fa-comment-alt','commentdollar' => 'fas fa-comment-dollar','commentdots' => 'fas fa-comment-dots','commentdots' => 'far fa-comment-dots','commentslash' => 'fas fa-comment-slash','comments' => 'fas fa-comments','comments' => 'far fa-comments','commentsdollar' => 'fas fa-comments-dollar','compactdisc' => 'fas fa-compact-disc','compass' => 'fas fa-compass','compass' => 'far fa-compass','compress' => 'fas fa-compress','conciergebell' => 'fas fa-concierge-bell','connectdevelop' => 'fab fa-connectdevelop','contao' => 'fab fa-contao','cookie' => 'fas fa-cookie','cookiebite' => 'fas fa-cookie-bite','copy' => 'fas fa-copy','copy' => 'far fa-copy','copyright' => 'fas fa-copyright','copyright' => 'far fa-copyright','couch' => 'fas fa-couch','cpanel' => 'fab fa-cpanel','creativecommons' => 'fab fa-creative-commons','creativecommonsby' => 'fab fa-creative-commons-by','creativecommonsnc' => 'fab fa-creative-commons-nc','creativecommonsnceu' => 'fab fa-creative-commons-nc-eu','creativecommonsncjp' => 'fab fa-creative-commons-nc-jp','creativecommonsnd' => 'fab fa-creative-commons-nd','creativecommonspd' => 'fab fa-creative-commons-pd','creativecommonspdalt' => 'fab fa-creative-commons-pd-alt','creativecommonsremix' => 'fab fa-creative-commons-remix','creativecommonssa' => 'fab fa-creative-commons-sa','creativecommonssampling' => 'fab fa-creative-commons-sampling','creativecommonssamplingplus' => 'fab fa-creative-commons-sampling-plus','creativecommonsshare' => 'fab fa-creative-commons-share','creativecommonszero' => 'fab fa-creative-commons-zero','creditcard' => 'fas fa-credit-card','creditcard' => 'far fa-credit-card','criticalrole' => 'fab fa-critical-role','crop' => 'fas fa-crop','cropalt' => 'fas fa-crop-alt','cross' => 'fas fa-cross','crosshairs' => 'fas fa-crosshairs','crow' => 'fas fa-crow','crown' => 'fas fa-crown','css3' => 'fab fa-css3','css3alt' => 'fab fa-css3-alt','cube' => 'fas fa-cube','cubes' => 'fas fa-cubes','cut' => 'fas fa-cut','cuttlefish' => 'fab fa-cuttlefish','dandd' => 'fab fa-d-and-d','danddbeyond' => 'fab fa-d-and-d-beyond','dashcube' => 'fab fa-dashcube','database' => 'fas fa-database','deaf' => 'fas fa-deaf','delicious' => 'fab fa-delicious','democrat' => 'fas fa-democrat','deploydog' => 'fab fa-deploydog','deskpro' => 'fab fa-deskpro','desktop' => 'fas fa-desktop','dev' => 'fab fa-dev','deviantart' => 'fab fa-deviantart','dharmachakra' => 'fas fa-dharmachakra','diagnoses' => 'fas fa-diagnoses','dice' => 'fas fa-dice','diced20' => 'fas fa-dice-d20','diced6' => 'fas fa-dice-d6','dicefive' => 'fas fa-dice-five','dicefour' => 'fas fa-dice-four','diceone' => 'fas fa-dice-one','dicesix' => 'fas fa-dice-six','dicethree' => 'fas fa-dice-three','dicetwo' => 'fas fa-dice-two','digg' => 'fab fa-digg','digitalocean' => 'fab fa-digital-ocean','digitaltachograph' => 'fas fa-digital-tachograph','directions' => 'fas fa-directions','discord' => 'fab fa-discord','discourse' => 'fab fa-discourse','divide' => 'fas fa-divide','dizzy' => 'fas fa-dizzy','dizzy' => 'far fa-dizzy','dna' => 'fas fa-dna','dochub' => 'fab fa-dochub','docker' => 'fab fa-docker','dog' => 'fas fa-dog','dollarsign' => 'fas fa-dollar-sign','dolly' => 'fas fa-dolly','dollyflatbed' => 'fas fa-dolly-flatbed','donate' => 'fas fa-donate','doorclosed' => 'fas fa-door-closed','dooropen' => 'fas fa-door-open','dotcircle' => 'fas fa-dot-circle','dotcircle' => 'far fa-dot-circle','dove' => 'fas fa-dove','download' => 'fas fa-download','draft2digital' => 'fab fa-draft2digital','draftingcompass' => 'fas fa-drafting-compass','dragon' => 'fas fa-dragon','drawpolygon' => 'fas fa-draw-polygon','dribbble' => 'fab fa-dribbble','dribbblesquare' => 'fab fa-dribbble-square','dropbox' => 'fab fa-dropbox','drum' => 'fas fa-drum','drumsteelpan' => 'fas fa-drum-steelpan','drumstickbite' => 'fas fa-drumstick-bite','drupal' => 'fab fa-drupal','dumbbell' => 'fas fa-dumbbell','dungeon' => 'fas fa-dungeon','dyalog' => 'fab fa-dyalog','earlybirds' => 'fab fa-earlybirds','ebay' => 'fab fa-ebay','edge' => 'fab fa-edge','edit' => 'fas fa-edit','edit' => 'far fa-edit','eject' => 'fas fa-eject','elementor' => 'fab fa-elementor','ellipsish' => 'fas fa-ellipsis-h','ellipsisv' => 'fas fa-ellipsis-v','ello' => 'fab fa-ello','ember' => 'fab fa-ember','empire' => 'fab fa-empire','envelope' => 'fas fa-envelope','envelope' => 'far fa-envelope','envelopeopen' => 'fas fa-envelope-open','envelopeopen' => 'far fa-envelope-open','envelopeopentext' => 'fas fa-envelope-open-text','envelopesquare' => 'fas fa-envelope-square','envira' => 'fab fa-envira','equals' => 'fas fa-equals','eraser' => 'fas fa-eraser','erlang' => 'fab fa-erlang','ethereum' => 'fab fa-ethereum','etsy' => 'fab fa-etsy','eurosign' => 'fas fa-euro-sign','exchangealt' => 'fas fa-exchange-alt','exclamation' => 'fas fa-exclamation','exclamationcircle' => 'fas fa-exclamation-circle','exclamationtriangle' => 'fas fa-exclamation-triangle','expand' => 'fas fa-expand','expandarrowsalt' => 'fas fa-expand-arrows-alt','expeditedssl' => 'fab fa-expeditedssl','externallinkalt' => 'fas fa-external-link-alt','externallinksquarealt' => 'fas fa-external-link-square-alt','eye' => 'fas fa-eye','eye' => 'far fa-eye','eyedropper' => 'fas fa-eye-dropper','eyeslash' => 'fas fa-eye-slash','eyeslash' => 'far fa-eye-slash','facebook' => 'fab fa-facebook','facebookf' => 'fab fa-facebook-f','facebookmessenger' => 'fab fa-facebook-messenger','facebooksquare' => 'fab fa-facebook-square','fantasyflightgames' => 'fab fa-fantasy-flight-games','fastbackward' => 'fas fa-fast-backward','fastforward' => 'fas fa-fast-forward','fax' => 'fas fa-fax','feather' => 'fas fa-feather','featheralt' => 'fas fa-feather-alt','female' => 'fas fa-female','fighterjet' => 'fas fa-fighter-jet','file' => 'fas fa-file','file' => 'far fa-file','filealt' => 'fas fa-file-alt','filealt' => 'far fa-file-alt','filearchive' => 'fas fa-file-archive','filearchive' => 'far fa-file-archive','fileaudio' => 'fas fa-file-audio','fileaudio' => 'far fa-file-audio','filecode' => 'fas fa-file-code','filecode' => 'far fa-file-code','filecontract' => 'fas fa-file-contract','filecsv' => 'fas fa-file-csv','filedownload' => 'fas fa-file-download','fileexcel' => 'fas fa-file-excel','fileexcel' => 'far fa-file-excel','fileexport' => 'fas fa-file-export','fileimage' => 'fas fa-file-image','fileimage' => 'far fa-file-image','fileimport' => 'fas fa-file-import','fileinvoice' => 'fas fa-file-invoice','fileinvoicedollar' => 'fas fa-file-invoice-dollar','filemedical' => 'fas fa-file-medical','filemedicalalt' => 'fas fa-file-medical-alt','filepdf' => 'fas fa-file-pdf','filepdf' => 'far fa-file-pdf','filepowerpoint' => 'fas fa-file-powerpoint','filepowerpoint' => 'far fa-file-powerpoint','fileprescription' => 'fas fa-file-prescription','filesignature' => 'fas fa-file-signature','fileupload' => 'fas fa-file-upload','filevideo' => 'fas fa-file-video','filevideo' => 'far fa-file-video','fileword' => 'fas fa-file-word','fileword' => 'far fa-file-word','fill' => 'fas fa-fill','filldrip' => 'fas fa-fill-drip','film' => 'fas fa-film','filter' => 'fas fa-filter','fingerprint' => 'fas fa-fingerprint','fire' => 'fas fa-fire','fireextinguisher' => 'fas fa-fire-extinguisher','firefox' => 'fab fa-firefox','firstaid' => 'fas fa-first-aid','firstorder' => 'fab fa-first-order','firstorderalt' => 'fab fa-first-order-alt','firstdraft' => 'fab fa-firstdraft','fish' => 'fas fa-fish','fistraised' => 'fas fa-fist-raised','flag' => 'fas fa-flag','flag' => 'far fa-flag','flagcheckered' => 'fas fa-flag-checkered','flagusa' => 'fas fa-flag-usa','flask' => 'fas fa-flask','flickr' => 'fab fa-flickr','flipboard' => 'fab fa-flipboard','flushed' => 'fas fa-flushed','flushed' => 'far fa-flushed','fly' => 'fab fa-fly','folder' => 'fas fa-folder','folder' => 'far fa-folder','folderminus' => 'fas fa-folder-minus','folderopen' => 'fas fa-folder-open','folderopen' => 'far fa-folder-open','folderplus' => 'fas fa-folder-plus','font' => 'fas fa-font','fontawesome' => 'fab fa-font-awesome','fontawesomealt' => 'fab fa-font-awesome-alt','fontawesomeflag' => 'fab fa-font-awesome-flag','fontawesomelogofull' => 'far fa-font-awesome-logo-full','fontawesomelogofull' => 'fas fa-font-awesome-logo-full','fontawesomelogofull' => 'fab fa-font-awesome-logo-full','fonticons' => 'fab fa-fonticons','fonticonsfi' => 'fab fa-fonticons-fi','footballball' => 'fas fa-football-ball','fortawesome' => 'fab fa-fort-awesome','fortawesomealt' => 'fab fa-fort-awesome-alt','forumbee' => 'fab fa-forumbee','forward' => 'fas fa-forward','foursquare' => 'fab fa-foursquare','freecodecamp' => 'fab fa-free-code-camp','freebsd' => 'fab fa-freebsd','frog' => 'fas fa-frog','frown' => 'fas fa-frown','frown' => 'far fa-frown','frownopen' => 'fas fa-frown-open','frownopen' => 'far fa-frown-open','fulcrum' => 'fab fa-fulcrum','funneldollar' => 'fas fa-funnel-dollar','futbol' => 'fas fa-futbol','futbol' => 'far fa-futbol','galacticrepublic' => 'fab fa-galactic-republic','galacticsenate' => 'fab fa-galactic-senate','gamepad' => 'fas fa-gamepad','gaspump' => 'fas fa-gas-pump','gavel' => 'fas fa-gavel','gem' => 'fas fa-gem','gem' => 'far fa-gem','genderless' => 'fas fa-genderless','getpocket' => 'fab fa-get-pocket','gg' => 'fab fa-gg','ggcircle' => 'fab fa-gg-circle','ghost' => 'fas fa-ghost','gift' => 'fas fa-gift','git' => 'fab fa-git','gitsquare' => 'fab fa-git-square','github' => 'fab fa-github','githubalt' => 'fab fa-github-alt','githubsquare' => 'fab fa-github-square','gitkraken' => 'fab fa-gitkraken','gitlab' => 'fab fa-gitlab','gitter' => 'fab fa-gitter','glassmartini' => 'fas fa-glass-martini','glassmartinialt' => 'fas fa-glass-martini-alt','glasses' => 'fas fa-glasses','glide' => 'fab fa-glide','glideg' => 'fab fa-glide-g','globe' => 'fas fa-globe','globeafrica' => 'fas fa-globe-africa','globeamericas' => 'fas fa-globe-americas','globeasia' => 'fas fa-globe-asia','gofore' => 'fab fa-gofore','golfball' => 'fas fa-golf-ball','goodreads' => 'fab fa-goodreads','goodreadsg' => 'fab fa-goodreads-g','google' => 'fab fa-google','googledrive' => 'fab fa-google-drive','googleplay' => 'fab fa-google-play','googleplus' => 'fab fa-google-plus','googleplusg' => 'fab fa-google-plus-g','googleplussquare' => 'fab fa-google-plus-square','googlewallet' => 'fab fa-google-wallet','gopuram' => 'fas fa-gopuram','graduationcap' => 'fas fa-graduation-cap','gratipay' => 'fab fa-gratipay','grav' => 'fab fa-grav','greaterthan' => 'fas fa-greater-than','greaterthanequal' => 'fas fa-greater-than-equal','grimace' => 'fas fa-grimace','grimace' => 'far fa-grimace','grin' => 'fas fa-grin','grin' => 'far fa-grin','grinalt' => 'fas fa-grin-alt','grinalt' => 'far fa-grin-alt','grinbeam' => 'fas fa-grin-beam','grinbeam' => 'far fa-grin-beam','grinbeamsweat' => 'fas fa-grin-beam-sweat','grinbeamsweat' => 'far fa-grin-beam-sweat','grinhearts' => 'fas fa-grin-hearts','grinhearts' => 'far fa-grin-hearts','grinsquint' => 'fas fa-grin-squint','grinsquint' => 'far fa-grin-squint','grinsquinttears' => 'fas fa-grin-squint-tears','grinsquinttears' => 'far fa-grin-squint-tears','grinstars' => 'fas fa-grin-stars','grinstars' => 'far fa-grin-stars','grintears' => 'fas fa-grin-tears','grintears' => 'far fa-grin-tears','grintongue' => 'fas fa-grin-tongue','grintongue' => 'far fa-grin-tongue','grintonguesquint' => 'fas fa-grin-tongue-squint','grintonguesquint' => 'far fa-grin-tongue-squint','grintonguewink' => 'fas fa-grin-tongue-wink','grintonguewink' => 'far fa-grin-tongue-wink','grinwink' => 'fas fa-grin-wink','grinwink' => 'far fa-grin-wink','griphorizontal' => 'fas fa-grip-horizontal','gripvertical' => 'fas fa-grip-vertical','gripfire' => 'fab fa-gripfire','grunt' => 'fab fa-grunt','gulp' => 'fab fa-gulp','hsquare' => 'fas fa-h-square','hackernews' => 'fab fa-hacker-news','hackernewssquare' => 'fab fa-hacker-news-square','hackerrank' => 'fab fa-hackerrank','hammer' => 'fas fa-hammer','hamsa' => 'fas fa-hamsa','handholding' => 'fas fa-hand-holding','handholdingheart' => 'fas fa-hand-holding-heart','handholdingusd' => 'fas fa-hand-holding-usd','handlizard' => 'fas fa-hand-lizard','handlizard' => 'far fa-hand-lizard','handpaper' => 'fas fa-hand-paper','handpaper' => 'far fa-hand-paper','handpeace' => 'fas fa-hand-peace','handpeace' => 'far fa-hand-peace','handpointdown' => 'fas fa-hand-point-down','handpointdown' => 'far fa-hand-point-down','handpointleft' => 'fas fa-hand-point-left','handpointleft' => 'far fa-hand-point-left','handpointright' => 'fas fa-hand-point-right','handpointright' => 'far fa-hand-point-right','handpointup' => 'fas fa-hand-point-up','handpointup' => 'far fa-hand-point-up','handpointer' => 'fas fa-hand-pointer','handpointer' => 'far fa-hand-pointer','handrock' => 'fas fa-hand-rock','handrock' => 'far fa-hand-rock','handscissors' => 'fas fa-hand-scissors','handscissors' => 'far fa-hand-scissors','handspock' => 'fas fa-hand-spock','handspock' => 'far fa-hand-spock','hands' => 'fas fa-hands','handshelping' => 'fas fa-hands-helping','handshake' => 'fas fa-handshake','handshake' => 'far fa-handshake','hanukiah' => 'fas fa-hanukiah','hashtag' => 'fas fa-hashtag','hatwizard' => 'fas fa-hat-wizard','haykal' => 'fas fa-haykal','hdd' => 'fas fa-hdd','hdd' => 'far fa-hdd','heading' => 'fas fa-heading','headphones' => 'fas fa-headphones','headphonesalt' => 'fas fa-headphones-alt','headset' => 'fas fa-headset','heart' => 'fas fa-heart','heart' => 'far fa-heart','heartbeat' => 'fas fa-heartbeat','helicopter' => 'fas fa-helicopter','highlighter' => 'fas fa-highlighter','hiking' => 'fas fa-hiking','hippo' => 'fas fa-hippo','hips' => 'fab fa-hips','hireahelper' => 'fab fa-hire-a-helper','history' => 'fas fa-history','hockeypuck' => 'fas fa-hockey-puck','home' => 'fas fa-home','hooli' => 'fab fa-hooli','hornbill' => 'fab fa-hornbill','horse' => 'fas fa-horse','hospital' => 'fas fa-hospital','hospital' => 'far fa-hospital','hospitalalt' => 'fas fa-hospital-alt','hospitalsymbol' => 'fas fa-hospital-symbol','hottub' => 'fas fa-hot-tub','hotel' => 'fas fa-hotel','hotjar' => 'fab fa-hotjar','hourglass' => 'fas fa-hourglass','hourglass' => 'far fa-hourglass','hourglassend' => 'fas fa-hourglass-end','hourglasshalf' => 'fas fa-hourglass-half','hourglassstart' => 'fas fa-hourglass-start','housedamage' => 'fas fa-house-damage','houzz' => 'fab fa-houzz','hryvnia' => 'fas fa-hryvnia','html5' => 'fab fa-html5','hubspot' => 'fab fa-hubspot','icursor' => 'fas fa-i-cursor','idbadge' => 'fas fa-id-badge','idbadge' => 'far fa-id-badge','idcard' => 'fas fa-id-card','idcard' => 'far fa-id-card','idcardalt' => 'fas fa-id-card-alt','image' => 'fas fa-image','image' => 'far fa-image','images' => 'fas fa-images','images' => 'far fa-images','imdb' => 'fab fa-imdb','inbox' => 'fas fa-inbox','indent' => 'fas fa-indent','industry' => 'fas fa-industry','infinity' => 'fas fa-infinity','info' => 'fas fa-info','infocircle' => 'fas fa-info-circle','instagram' => 'fab fa-instagram','internetexplorer' => 'fab fa-internet-explorer','ioxhost' => 'fab fa-ioxhost','italic' => 'fas fa-italic','itunes' => 'fab fa-itunes','itunesnote' => 'fab fa-itunes-note','java' => 'fab fa-java','jedi' => 'fas fa-jedi','jediorder' => 'fab fa-jedi-order','jenkins' => 'fab fa-jenkins','joget' => 'fab fa-joget','joint' => 'fas fa-joint','joomla' => 'fab fa-joomla','journalwhills' => 'fas fa-journal-whills','js' => 'fab fa-js','jssquare' => 'fab fa-js-square','jsfiddle' => 'fab fa-jsfiddle','kaaba' => 'fas fa-kaaba','kaggle' => 'fab fa-kaggle','key' => 'fas fa-key','keybase' => 'fab fa-keybase','keyboard' => 'fas fa-keyboard','keyboard' => 'far fa-keyboard','keycdn' => 'fab fa-keycdn','khanda' => 'fas fa-khanda','kickstarter' => 'fab fa-kickstarter','kickstarterk' => 'fab fa-kickstarter-k','kiss' => 'fas fa-kiss','kiss' => 'far fa-kiss','kissbeam' => 'fas fa-kiss-beam','kissbeam' => 'far fa-kiss-beam','kisswinkheart' => 'fas fa-kiss-wink-heart','kisswinkheart' => 'far fa-kiss-wink-heart','kiwibird' => 'fas fa-kiwi-bird','korvue' => 'fab fa-korvue','landmark' => 'fas fa-landmark','language' => 'fas fa-language','laptop' => 'fas fa-laptop','laptopcode' => 'fas fa-laptop-code','laravel' => 'fab fa-laravel','lastfm' => 'fab fa-lastfm','lastfmsquare' => 'fab fa-lastfm-square','laugh' => 'fas fa-laugh','laugh' => 'far fa-laugh','laughbeam' => 'fas fa-laugh-beam','laughbeam' => 'far fa-laugh-beam','laughsquint' => 'fas fa-laugh-squint','laughsquint' => 'far fa-laugh-squint','laughwink' => 'fas fa-laugh-wink','laughwink' => 'far fa-laugh-wink','layergroup' => 'fas fa-layer-group','leaf' => 'fas fa-leaf','leanpub' => 'fab fa-leanpub','lemon' => 'fas fa-lemon','lemon' => 'far fa-lemon','less' => 'fab fa-less','lessthan' => 'fas fa-less-than','lessthanequal' => 'fas fa-less-than-equal','leveldownalt' => 'fas fa-level-down-alt','levelupalt' => 'fas fa-level-up-alt','lifering' => 'fas fa-life-ring','lifering' => 'far fa-life-ring','lightbulb' => 'fas fa-lightbulb','lightbulb' => 'far fa-lightbulb','line' => 'fab fa-line','link' => 'fas fa-link','linkedin' => 'fab fa-linkedin','linkedinin' => 'fab fa-linkedin-in','linode' => 'fab fa-linode','linux' => 'fab fa-linux','lirasign' => 'fas fa-lira-sign','list' => 'fas fa-list','listalt' => 'fas fa-list-alt','listalt' => 'far fa-list-alt','listol' => 'fas fa-list-ol','listul' => 'fas fa-list-ul','locationarrow' => 'fas fa-location-arrow','lock' => 'fas fa-lock','lockopen' => 'fas fa-lock-open','longarrowaltdown' => 'fas fa-long-arrow-alt-down','longarrowaltleft' => 'fas fa-long-arrow-alt-left','longarrowaltright' => 'fas fa-long-arrow-alt-right','longarrowaltup' => 'fas fa-long-arrow-alt-up','lowvision' => 'fas fa-low-vision','luggagecart' => 'fas fa-luggage-cart','lyft' => 'fab fa-lyft','magento' => 'fab fa-magento','magic' => 'fas fa-magic','magnet' => 'fas fa-magnet','mailbulk' => 'fas fa-mail-bulk','mailchimp' => 'fab fa-mailchimp','male' => 'fas fa-male','mandalorian' => 'fab fa-mandalorian','map' => 'fas fa-map','map' => 'far fa-map','mapmarked' => 'fas fa-map-marked','mapmarkedalt' => 'fas fa-map-marked-alt','mapmarker' => 'fas fa-map-marker','mapmarkeralt' => 'fas fa-map-marker-alt','mappin' => 'fas fa-map-pin','mapsigns' => 'fas fa-map-signs','markdown' => 'fab fa-markdown','marker' => 'fas fa-marker','mars' => 'fas fa-mars','marsdouble' => 'fas fa-mars-double','marsstroke' => 'fas fa-mars-stroke','marsstrokeh' => 'fas fa-mars-stroke-h','marsstrokev' => 'fas fa-mars-stroke-v','mask' => 'fas fa-mask','mastodon' => 'fab fa-mastodon','maxcdn' => 'fab fa-maxcdn','medal' => 'fas fa-medal','medapps' => 'fab fa-medapps','medium' => 'fab fa-medium','mediumm' => 'fab fa-medium-m','medkit' => 'fas fa-medkit','medrt' => 'fab fa-medrt','meetup' => 'fab fa-meetup','megaport' => 'fab fa-megaport','meh' => 'fas fa-meh','meh' => 'far fa-meh','mehblank' => 'fas fa-meh-blank','mehblank' => 'far fa-meh-blank','mehrollingeyes' => 'fas fa-meh-rolling-eyes','mehrollingeyes' => 'far fa-meh-rolling-eyes','memory' => 'fas fa-memory','menorah' => 'fas fa-menorah','mercury' => 'fas fa-mercury','meteor' => 'fas fa-meteor','microchip' => 'fas fa-microchip','microphone' => 'fas fa-microphone','microphonealt' => 'fas fa-microphone-alt','microphonealtslash' => 'fas fa-microphone-alt-slash','microphoneslash' => 'fas fa-microphone-slash','microscope' => 'fas fa-microscope','microsoft' => 'fab fa-microsoft','minus' => 'fas fa-minus','minuscircle' => 'fas fa-minus-circle','minussquare' => 'fas fa-minus-square','minussquare' => 'far fa-minus-square','mix' => 'fab fa-mix','mixcloud' => 'fab fa-mixcloud','mizuni' => 'fab fa-mizuni','mobile' => 'fas fa-mobile','mobilealt' => 'fas fa-mobile-alt','modx' => 'fab fa-modx','monero' => 'fab fa-monero','moneybill' => 'fas fa-money-bill','moneybillalt' => 'fas fa-money-bill-alt','moneybillalt' => 'far fa-money-bill-alt','moneybillwave' => 'fas fa-money-bill-wave','moneybillwavealt' => 'fas fa-money-bill-wave-alt','moneycheck' => 'fas fa-money-check','moneycheckalt' => 'fas fa-money-check-alt','monument' => 'fas fa-monument','moon' => 'fas fa-moon','moon' => 'far fa-moon','mortarpestle' => 'fas fa-mortar-pestle','mosque' => 'fas fa-mosque','motorcycle' => 'fas fa-motorcycle','mountain' => 'fas fa-mountain','mousepointer' => 'fas fa-mouse-pointer','music' => 'fas fa-music','napster' => 'fab fa-napster','neos' => 'fab fa-neos','networkwired' => 'fas fa-network-wired','neuter' => 'fas fa-neuter','newspaper' => 'fas fa-newspaper','newspaper' => 'far fa-newspaper','nimblr' => 'fab fa-nimblr','nintendoswitch' => 'fab fa-nintendo-switch','node' => 'fab fa-node','nodejs' => 'fab fa-node-js','notequal' => 'fas fa-not-equal','notesmedical' => 'fas fa-notes-medical','npm' => 'fab fa-npm','ns8' => 'fab fa-ns8','nutritionix' => 'fab fa-nutritionix','objectgroup' => 'fas fa-object-group','objectgroup' => 'far fa-object-group','objectungroup' => 'fas fa-object-ungroup','objectungroup' => 'far fa-object-ungroup','odnoklassniki' => 'fab fa-odnoklassniki','odnoklassnikisquare' => 'fab fa-odnoklassniki-square','oilcan' => 'fas fa-oil-can','oldrepublic' => 'fab fa-old-republic','om' => 'fas fa-om','opencart' => 'fab fa-opencart','openid' => 'fab fa-openid','opera' => 'fab fa-opera','optinmonster' => 'fab fa-optin-monster','osi' => 'fab fa-osi','otter' => 'fas fa-otter','outdent' => 'fas fa-outdent','page4' => 'fab fa-page4','pagelines' => 'fab fa-pagelines','paintbrush' => 'fas fa-paint-brush','paintroller' => 'fas fa-paint-roller','palette' => 'fas fa-palette','palfed' => 'fab fa-palfed','pallet' => 'fas fa-pallet','paperplane' => 'fas fa-paper-plane','paperplane' => 'far fa-paper-plane','paperclip' => 'fas fa-paperclip','parachutebox' => 'fas fa-parachute-box','paragraph' => 'fas fa-paragraph','parking' => 'fas fa-parking','passport' => 'fas fa-passport','pastafarianism' => 'fas fa-pastafarianism','paste' => 'fas fa-paste','patreon' => 'fab fa-patreon','pause' => 'fas fa-pause','pausecircle' => 'fas fa-pause-circle','pausecircle' => 'far fa-pause-circle','paw' => 'fas fa-paw','paypal' => 'fab fa-paypal','peace' => 'fas fa-peace','pen' => 'fas fa-pen','penalt' => 'fas fa-pen-alt','penfancy' => 'fas fa-pen-fancy','pennib' => 'fas fa-pen-nib','pensquare' => 'fas fa-pen-square','pencilalt' => 'fas fa-pencil-alt','pencilruler' => 'fas fa-pencil-ruler','pennyarcade' => 'fab fa-penny-arcade','peoplecarry' => 'fas fa-people-carry','percent' => 'fas fa-percent','percentage' => 'fas fa-percentage','periscope' => 'fab fa-periscope','personbooth' => 'fas fa-person-booth','phabricator' => 'fab fa-phabricator','phoenixframework' => 'fab fa-phoenix-framework','phoenixsquadron' => 'fab fa-phoenix-squadron','phone' => 'fas fa-phone','phoneslash' => 'fas fa-phone-slash','phonesquare' => 'fas fa-phone-square','phonevolume' => 'fas fa-phone-volume','php' => 'fab fa-php','piedpiper' => 'fab fa-pied-piper','piedpiperalt' => 'fab fa-pied-piper-alt','piedpiperhat' => 'fab fa-pied-piper-hat','piedpiperpp' => 'fab fa-pied-piper-pp','piggybank' => 'fas fa-piggy-bank','pills' => 'fas fa-pills','pinterest' => 'fab fa-pinterest','pinterestp' => 'fab fa-pinterest-p','pinterestsquare' => 'fab fa-pinterest-square','placeofworship' => 'fas fa-place-of-worship','plane' => 'fas fa-plane','planearrival' => 'fas fa-plane-arrival','planedeparture' => 'fas fa-plane-departure','play' => 'fas fa-play','playcircle' => 'fas fa-play-circle','playcircle' => 'far fa-play-circle','playstation' => 'fab fa-playstation','plug' => 'fas fa-plug','plus' => 'fas fa-plus','pluscircle' => 'fas fa-plus-circle','plussquare' => 'fas fa-plus-square','plussquare' => 'far fa-plus-square','podcast' => 'fas fa-podcast','poll' => 'fas fa-poll','pollh' => 'fas fa-poll-h','poo' => 'fas fa-poo','poostorm' => 'fas fa-poo-storm','poop' => 'fas fa-poop','portrait' => 'fas fa-portrait','poundsign' => 'fas fa-pound-sign','poweroff' => 'fas fa-power-off','pray' => 'fas fa-pray','prayinghands' => 'fas fa-praying-hands','prescription' => 'fas fa-prescription','prescriptionbottle' => 'fas fa-prescription-bottle','prescriptionbottlealt' => 'fas fa-prescription-bottle-alt','print' => 'fas fa-print','procedures' => 'fas fa-procedures','producthunt' => 'fab fa-product-hunt','projectdiagram' => 'fas fa-project-diagram','pushed' => 'fab fa-pushed','puzzlepiece' => 'fas fa-puzzle-piece','python' => 'fab fa-python','qq' => 'fab fa-qq','qrcode' => 'fas fa-qrcode','question' => 'fas fa-question','questioncircle' => 'fas fa-question-circle','questioncircle' => 'far fa-question-circle','quidditch' => 'fas fa-quidditch','quinscape' => 'fab fa-quinscape','quora' => 'fab fa-quora','quoteleft' => 'fas fa-quote-left','quoteright' => 'fas fa-quote-right','quran' => 'fas fa-quran','rproject' => 'fab fa-r-project','rainbow' => 'fas fa-rainbow','random' => 'fas fa-random','ravelry' => 'fab fa-ravelry','react' => 'fab fa-react','reacteurope' => 'fab fa-reacteurope','readme' => 'fab fa-readme','rebel' => 'fab fa-rebel','receipt' => 'fas fa-receipt','recycle' => 'fas fa-recycle','redriver' => 'fab fa-red-river','reddit' => 'fab fa-reddit','redditalien' => 'fab fa-reddit-alien','redditsquare' => 'fab fa-reddit-square','redo' => 'fas fa-redo','redoalt' => 'fas fa-redo-alt','registered' => 'fas fa-registered','registered' => 'far fa-registered','renren' => 'fab fa-renren','reply' => 'fas fa-reply','replyall' => 'fas fa-reply-all','replyd' => 'fab fa-replyd','republican' => 'fas fa-republican','researchgate' => 'fab fa-researchgate','resolving' => 'fab fa-resolving','retweet' => 'fas fa-retweet','rev' => 'fab fa-rev','ribbon' => 'fas fa-ribbon','ring' => 'fas fa-ring','road' => 'fas fa-road','robot' => 'fas fa-robot','rocket' => 'fas fa-rocket','rocketchat' => 'fab fa-rocketchat','rockrms' => 'fab fa-rockrms','route' => 'fas fa-route','rss' => 'fas fa-rss','rsssquare' => 'fas fa-rss-square','rublesign' => 'fas fa-ruble-sign','ruler' => 'fas fa-ruler','rulercombined' => 'fas fa-ruler-combined','rulerhorizontal' => 'fas fa-ruler-horizontal','rulervertical' => 'fas fa-ruler-vertical','running' => 'fas fa-running','rupeesign' => 'fas fa-rupee-sign','sadcry' => 'fas fa-sad-cry','sadcry' => 'far fa-sad-cry','sadtear' => 'fas fa-sad-tear','sadtear' => 'far fa-sad-tear','safari' => 'fab fa-safari','sass' => 'fab fa-sass','save' => 'fas fa-save','save' => 'far fa-save','schlix' => 'fab fa-schlix','school' => 'fas fa-school','screwdriver' => 'fas fa-screwdriver','scribd' => 'fab fa-scribd','scroll' => 'fas fa-scroll','search' => 'fas fa-search','searchdollar' => 'fas fa-search-dollar','searchlocation' => 'fas fa-search-location','searchminus' => 'fas fa-search-minus','searchplus' => 'fas fa-search-plus','searchengin' => 'fab fa-searchengin','seedling' => 'fas fa-seedling','sellcast' => 'fab fa-sellcast','sellsy' => 'fab fa-sellsy','server' => 'fas fa-server','servicestack' => 'fab fa-servicestack','shapes' => 'fas fa-shapes','share' => 'fas fa-share','sharealt' => 'fas fa-share-alt','sharealtsquare' => 'fas fa-share-alt-square','sharesquare' => 'fas fa-share-square','sharesquare' => 'far fa-share-square','shekelsign' => 'fas fa-shekel-sign','shieldalt' => 'fas fa-shield-alt','ship' => 'fas fa-ship','shippingfast' => 'fas fa-shipping-fast','shirtsinbulk' => 'fab fa-shirtsinbulk','shoeprints' => 'fas fa-shoe-prints','shoppingbag' => 'fas fa-shopping-bag','shoppingbasket' => 'fas fa-shopping-basket','shoppingcart' => 'fas fa-shopping-cart','shopware' => 'fab fa-shopware','shower' => 'fas fa-shower','shuttlevan' => 'fas fa-shuttle-van','sign' => 'fas fa-sign','signinalt' => 'fas fa-sign-in-alt','signlanguage' => 'fas fa-sign-language','signoutalt' => 'fas fa-sign-out-alt','signal' => 'fas fa-signal','signature' => 'fas fa-signature','simplybuilt' => 'fab fa-simplybuilt','sistrix' => 'fab fa-sistrix','sitemap' => 'fas fa-sitemap','sith' => 'fab fa-sith','skull' => 'fas fa-skull','skullcrossbones' => 'fas fa-skull-crossbones','skyatlas' => 'fab fa-skyatlas','skype' => 'fab fa-skype','slack' => 'fab fa-slack','slackhash' => 'fab fa-slack-hash','slash' => 'fas fa-slash','slidersh' => 'fas fa-sliders-h','slideshare' => 'fab fa-slideshare','smile' => 'fas fa-smile','smile' => 'far fa-smile','smilebeam' => 'fas fa-smile-beam','smilebeam' => 'far fa-smile-beam','smilewink' => 'fas fa-smile-wink','smilewink' => 'far fa-smile-wink','smog' => 'fas fa-smog','smoking' => 'fas fa-smoking','smokingban' => 'fas fa-smoking-ban','snapchat' => 'fab fa-snapchat','snapchatghost' => 'fab fa-snapchat-ghost','snapchatsquare' => 'fab fa-snapchat-square','snowflake' => 'fas fa-snowflake','snowflake' => 'far fa-snowflake','socks' => 'fas fa-socks','solarpanel' => 'fas fa-solar-panel','sort' => 'fas fa-sort','sortalphadown' => 'fas fa-sort-alpha-down','sortalphaup' => 'fas fa-sort-alpha-up','sortamountdown' => 'fas fa-sort-amount-down','sortamountup' => 'fas fa-sort-amount-up','sortdown' => 'fas fa-sort-down','sortnumericdown' => 'fas fa-sort-numeric-down','sortnumericup' => 'fas fa-sort-numeric-up','sortup' => 'fas fa-sort-up','soundcloud' => 'fab fa-soundcloud','spa' => 'fas fa-spa','spaceshuttle' => 'fas fa-space-shuttle','speakap' => 'fab fa-speakap','spider' => 'fas fa-spider','spinner' => 'fas fa-spinner','splotch' => 'fas fa-splotch','spotify' => 'fab fa-spotify','spraycan' => 'fas fa-spray-can','square' => 'fas fa-square','square' => 'far fa-square','squarefull' => 'fas fa-square-full','squarerootalt' => 'fas fa-square-root-alt','squarespace' => 'fab fa-squarespace','stackexchange' => 'fab fa-stack-exchange','stackoverflow' => 'fab fa-stack-overflow','stamp' => 'fas fa-stamp','star' => 'fas fa-star','star' => 'far fa-star','starandcrescent' => 'fas fa-star-and-crescent','starhalf' => 'fas fa-star-half','starhalf' => 'far fa-star-half','starhalfalt' => 'fas fa-star-half-alt','starofdavid' => 'fas fa-star-of-david','staroflife' => 'fas fa-star-of-life','staylinked' => 'fab fa-staylinked','steam' => 'fab fa-steam','steamsquare' => 'fab fa-steam-square','steamsymbol' => 'fab fa-steam-symbol','stepbackward' => 'fas fa-step-backward','stepforward' => 'fas fa-step-forward','stethoscope' => 'fas fa-stethoscope','stickermule' => 'fab fa-sticker-mule','stickynote' => 'fas fa-sticky-note','stickynote' => 'far fa-sticky-note','stop' => 'fas fa-stop','stopcircle' => 'fas fa-stop-circle','stopcircle' => 'far fa-stop-circle','stopwatch' => 'fas fa-stopwatch','store' => 'fas fa-store','storealt' => 'fas fa-store-alt','strava' => 'fab fa-strava','stream' => 'fas fa-stream','streetview' => 'fas fa-street-view','strikethrough' => 'fas fa-strikethrough','stripe' => 'fab fa-stripe','stripes' => 'fab fa-stripe-s','stroopwafel' => 'fas fa-stroopwafel','studiovinari' => 'fab fa-studiovinari','stumbleupon' => 'fab fa-stumbleupon','stumbleuponcircle' => 'fab fa-stumbleupon-circle','subscript' => 'fas fa-subscript','subway' => 'fas fa-subway','suitcase' => 'fas fa-suitcase','suitcaserolling' => 'fas fa-suitcase-rolling','sun' => 'fas fa-sun','sun' => 'far fa-sun','superpowers' => 'fab fa-superpowers','superscript' => 'fas fa-superscript','supple' => 'fab fa-supple','surprise' => 'fas fa-surprise','surprise' => 'far fa-surprise','swatchbook' => 'fas fa-swatchbook','swimmer' => 'fas fa-swimmer','swimmingpool' => 'fas fa-swimming-pool','synagogue' => 'fas fa-synagogue','sync' => 'fas fa-sync','syncalt' => 'fas fa-sync-alt','syringe' => 'fas fa-syringe','table' => 'fas fa-table','tabletennis' => 'fas fa-table-tennis','tablet' => 'fas fa-tablet','tabletalt' => 'fas fa-tablet-alt','tablets' => 'fas fa-tablets','tachometeralt' => 'fas fa-tachometer-alt','tag' => 'fas fa-tag','tags' => 'fas fa-tags','tape' => 'fas fa-tape','tasks' => 'fas fa-tasks','taxi' => 'fas fa-taxi','teamspeak' => 'fab fa-teamspeak','teeth' => 'fas fa-teeth','teethopen' => 'fas fa-teeth-open','telegram' => 'fab fa-telegram','telegramplane' => 'fab fa-telegram-plane','temperaturehigh' => 'fas fa-temperature-high','temperaturelow' => 'fas fa-temperature-low','tencentweibo' => 'fab fa-tencent-weibo','terminal' => 'fas fa-terminal','textheight' => 'fas fa-text-height','textwidth' => 'fas fa-text-width','th' => 'fas fa-th','thlarge' => 'fas fa-th-large','thlist' => 'fas fa-th-list','theredyeti' => 'fab fa-the-red-yeti','theatermasks' => 'fas fa-theater-masks','themeco' => 'fab fa-themeco','themeisle' => 'fab fa-themeisle','thermometer' => 'fas fa-thermometer','thermometerempty' => 'fas fa-thermometer-empty','thermometerfull' => 'fas fa-thermometer-full','thermometerhalf' => 'fas fa-thermometer-half','thermometerquarter' => 'fas fa-thermometer-quarter','thermometerthreequarters' => 'fas fa-thermometer-three-quarters','thinkpeaks' => 'fab fa-think-peaks','thumbsdown' => 'fas fa-thumbs-down','thumbsdown' => 'far fa-thumbs-down','thumbsup' => 'fas fa-thumbs-up','thumbsup' => 'far fa-thumbs-up','thumbtack' => 'fas fa-thumbtack','ticketalt' => 'fas fa-ticket-alt','times' => 'fas fa-times','timescircle' => 'fas fa-times-circle','timescircle' => 'far fa-times-circle','tint' => 'fas fa-tint','tintslash' => 'fas fa-tint-slash','tired' => 'fas fa-tired','tired' => 'far fa-tired','toggleoff' => 'fas fa-toggle-off','toggleon' => 'fas fa-toggle-on','toiletpaper' => 'fas fa-toilet-paper','toolbox' => 'fas fa-toolbox','tooth' => 'fas fa-tooth','torah' => 'fas fa-torah','toriigate' => 'fas fa-torii-gate','tractor' => 'fas fa-tractor','tradefederation' => 'fab fa-trade-federation','trademark' => 'fas fa-trademark','trafficlight' => 'fas fa-traffic-light','train' => 'fas fa-train','transgender' => 'fas fa-transgender','transgenderalt' => 'fas fa-transgender-alt','trash' => 'fas fa-trash','trashalt' => 'fas fa-trash-alt','trashalt' => 'far fa-trash-alt','tree' => 'fas fa-tree','trello' => 'fab fa-trello','tripadvisor' => 'fab fa-tripadvisor','trophy' => 'fas fa-trophy','truck' => 'fas fa-truck','truckloading' => 'fas fa-truck-loading','truckmonster' => 'fas fa-truck-monster','truckmoving' => 'fas fa-truck-moving','truckpickup' => 'fas fa-truck-pickup','tshirt' => 'fas fa-tshirt','tty' => 'fas fa-tty','tumblr' => 'fab fa-tumblr','tumblrsquare' => 'fab fa-tumblr-square','tv' => 'fas fa-tv','twitch' => 'fab fa-twitch','twitter' => 'fab fa-twitter','twittersquare' => 'fab fa-twitter-square','typo3' => 'fab fa-typo3','uber' => 'fab fa-uber','uikit' => 'fab fa-uikit','umbrella' => 'fas fa-umbrella','umbrellabeach' => 'fas fa-umbrella-beach','underline' => 'fas fa-underline','undo' => 'fas fa-undo','undoalt' => 'fas fa-undo-alt','uniregistry' => 'fab fa-uniregistry','universalaccess' => 'fas fa-universal-access','university' => 'fas fa-university','unlink' => 'fas fa-unlink','unlock' => 'fas fa-unlock','unlockalt' => 'fas fa-unlock-alt','untappd' => 'fab fa-untappd','upload' => 'fas fa-upload','usb' => 'fab fa-usb','user' => 'fas fa-user','user' => 'far fa-user','useralt' => 'fas fa-user-alt','useraltslash' => 'fas fa-user-alt-slash','userastronaut' => 'fas fa-user-astronaut','usercheck' => 'fas fa-user-check','usercircle' => 'fas fa-user-circle','usercircle' => 'far fa-user-circle','userclock' => 'fas fa-user-clock','usercog' => 'fas fa-user-cog','useredit' => 'fas fa-user-edit','userfriends' => 'fas fa-user-friends','usergraduate' => 'fas fa-user-graduate','userinjured' => 'fas fa-user-injured','userlock' => 'fas fa-user-lock','usermd' => 'fas fa-user-md','userminus' => 'fas fa-user-minus','userninja' => 'fas fa-user-ninja','userplus' => 'fas fa-user-plus','usersecret' => 'fas fa-user-secret','usershield' => 'fas fa-user-shield','userslash' => 'fas fa-user-slash','usertag' => 'fas fa-user-tag','usertie' => 'fas fa-user-tie','usertimes' => 'fas fa-user-times','users' => 'fas fa-users','userscog' => 'fas fa-users-cog','ussunnah' => 'fab fa-ussunnah','utensilspoon' => 'fas fa-utensil-spoon','utensils' => 'fas fa-utensils','vaadin' => 'fab fa-vaadin','vectorsquare' => 'fas fa-vector-square','venus' => 'fas fa-venus','venusdouble' => 'fas fa-venus-double','venusmars' => 'fas fa-venus-mars','viacoin' => 'fab fa-viacoin','viadeo' => 'fab fa-viadeo','viadeosquare' => 'fab fa-viadeo-square','vial' => 'fas fa-vial','vials' => 'fas fa-vials','viber' => 'fab fa-viber','video' => 'fas fa-video','videoslash' => 'fas fa-video-slash','vihara' => 'fas fa-vihara','vimeo' => 'fab fa-vimeo','vimeosquare' => 'fab fa-vimeo-square','vimeov' => 'fab fa-vimeo-v','vine' => 'fab fa-vine','vk' => 'fab fa-vk','vnv' => 'fab fa-vnv','volleyballball' => 'fas fa-volleyball-ball','volumedown' => 'fas fa-volume-down','volumemute' => 'fas fa-volume-mute','volumeoff' => 'fas fa-volume-off','volumeup' => 'fas fa-volume-up','voteyea' => 'fas fa-vote-yea','vrcardboard' => 'fas fa-vr-cardboard','vuejs' => 'fab fa-vuejs','walking' => 'fas fa-walking','wallet' => 'fas fa-wallet','warehouse' => 'fas fa-warehouse','water' => 'fas fa-water','weebly' => 'fab fa-weebly','weibo' => 'fab fa-weibo','weight' => 'fas fa-weight','weighthanging' => 'fas fa-weight-hanging','weixin' => 'fab fa-weixin','whatsapp' => 'fab fa-whatsapp','whatsappsquare' => 'fab fa-whatsapp-square','wheelchair' => 'fas fa-wheelchair','whmcs' => 'fab fa-whmcs','wifi' => 'fas fa-wifi','wikipediaw' => 'fab fa-wikipedia-w','wind' => 'fas fa-wind','windowclose' => 'fas fa-window-close','windowclose' => 'far fa-window-close','windowmaximize' => 'fas fa-window-maximize','windowmaximize' => 'far fa-window-maximize','windowminimize' => 'fas fa-window-minimize','windowminimize' => 'far fa-window-minimize','windowrestore' => 'fas fa-window-restore','windowrestore' => 'far fa-window-restore','windows' => 'fab fa-windows','winebottle' => 'fas fa-wine-bottle','wineglass' => 'fas fa-wine-glass','wineglassalt' => 'fas fa-wine-glass-alt','wix' => 'fab fa-wix','wizardsofthecoast' => 'fab fa-wizards-of-the-coast','wolfpackbattalion' => 'fab fa-wolf-pack-battalion','wonsign' => 'fas fa-won-sign','wordpress' => 'fab fa-wordpress','wordpresssimple' => 'fab fa-wordpress-simple','wpbeginner' => 'fab fa-wpbeginner','wpexplorer' => 'fab fa-wpexplorer','wpforms' => 'fab fa-wpforms','wpressr' => 'fab fa-wpressr','wrench' => 'fas fa-wrench','xray' => 'fas fa-x-ray','xbox' => 'fab fa-xbox','xing' => 'fab fa-xing','xingsquare' => 'fab fa-xing-square','ycombinator' => 'fab fa-y-combinator','yahoo' => 'fab fa-yahoo','yandex' => 'fab fa-yandex','yandexinternational' => 'fab fa-yandex-international','yelp' => 'fab fa-yelp','yensign' => 'fas fa-yen-sign','yinyang' => 'fas fa-yin-yang','yoast' => 'fab fa-yoast','youtube' => 'fab fa-youtube','youtubesquare' => 'fab fa-youtube-square','zhihu' => 'fab fa-zhihu'
        ];

        print ('<div id="wdes-menu-iconpicker" class="iconpicker-popover popover fade bottomLeft" style="display: none; left: 199px;">');
            print ('<div class="popover-title">');
                print ('<input type="search" id="wdes-iconpicker-search" class="form-control iconpicker-search" placeholder="Type to filter">');
            print ('</div>');
            print ('<div class="popover-content">');
                print ('<div class="iconpicker">');
                    print ('<div id="wdes-iconpicker-items" class="iconpicker-items">');
                        foreach ($icons_list as $icon_name => $icon_title){
                            printf('<a role="button" href="javascript:;" class="iconpicker-item" title="%2$s" data-search-terms="%1$s">', $icon_name , $icon_title);
                            printf ('<i class="%s"></i>', $icon_title);
                            print ('</a>');
                        }
                    print ('</div>');
                print ('</div>');
            print ('</div>');
        print ('</div>');
    }

	/**
	 * Wdes Custom Fields
	 *
	 * @param $item_id
	 * @param $item
	 *
	 */
	public function wdes_custom_fields($item_id, $item, $depth, $args)
	{

	    global $wp_registered_sidebars;

	    foreach ( $this->menu_item_fileds as $field_id => $field_info ){

            if( isset($field_info['depth']) ){
	            $data_depth = 'data-depth=' . json_encode([ 'min' => $field_info['depth']['min'], 'max' =>$field_info['depth']['max'] ]) . ' ';
            }else{
	            $data_depth = 'data-depth=' . json_encode([ 'min' => 0, 'max' =>0 ]) . '';
            }


	        switch ( $field_info['type'] ) {

                case 'checkbox':
                ?>
                <p class="wdes-menu-element field-<?php echo esc_attr( $field_id ); ?> description-wide wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                    <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
                        <?php esc_html_e($field_info['label'], 'phox') ?><br>
                        <input type="checkbox" id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" <?php checked($item->{$field_id}, '1') ?>>
                    </label>
                </p>
                <?php
                break;

		        case 'select':

			        ?>
                    <p class="wdes-menu-element field-<?php echo esc_attr( $field_id ); ?> description wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                        <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
					        <?php esc_html_e($field_info['label'], 'phox') ?><br>
                        </label>
                        <select id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" >
                            <?php
                            if( is_array( $field_info['options'] ) ){
	                            foreach ( $field_info['options'] as $option_id => $option_value  ){
                                    ?>
                                    <option value="<?php echo esc_attr($option_id) ?>" <?php selected( $item->{$field_id}, $option_id, true ); ?> > <?php echo esc_html( $option_value ) ?>  </option>
                                    <?php
	                            }
                            }
                            ?>
                        </select>
                    </p>
			        <?php
			        break;

		        case 'sidebars':
			        ?>
                    <p class="wdes-menu-element field-<?php echo esc_attr( $field_id ); ?> description wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                        <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
					        <?php esc_html_e($field_info['label'], 'phox') ?><br>
                        </label>
                        <select id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" >
                            <option value="0" <?php selected( $item->{$field_id}, 0, true ); ?> > <?php echo esc_html__( 'Select Widget Area', 'phox' ); ?>  </option>
					        <?php
					        if( is_array( $wp_registered_sidebars ) ){
						        foreach ( $wp_registered_sidebars as $sidebar  ){
							        ?>
                                    <option value="<?php echo esc_attr($sidebar['id']) ?>" <?php selected( $item->{$field_id}, $sidebar['id'], true ); ?> > <?php echo esc_html( $sidebar['name'] ); ?>  </option>
							        <?php
						        }
					        }
					        ?>
                        </select>
                    </p>
			        <?php
			        break;

                case 'icon':
                    ?>

                    <p class="wdes-menu-element description description-wide wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                        <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
			                <?php esc_html_e($field_info['label'], 'phox') ?><br>
                            <input type="text" id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" data-placement="bottomRight" class="widefat edit-menu-item-<?php echo esc_attr( $field_id )?> form-control icp icp-auto iconpicker-element wdes-iconpicker-input" value="<?php echo esc_html($item->{$field_id}); ?>">
                            <span class="input-group-addon"><i class="<?php echo esc_html($item->{$field_id}); ?>"></i></span>
                        </label>
                    </p>

                    <?php
                    break;

                case 'color':
	                ?>
                    <p class="wdes-menu-element description description-wide wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                        <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
	                        <?php esc_html_e($field_info['label'], 'phox') ?><br>
                        </label>
                        <input type="text" id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-<?php echo esc_attr( $field_id )?> wdes-color-selector" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" value="<?php echo esc_html($item->{$field_id}); ?>">

                    </p>

	                <?php
                    break;

		        case 'textarea':
			        ?>

                    <p class="wdes-menu-element description description-wide wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                        <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
					        <?php esc_html_e($field_info['label'], 'phox') ?><br>
                            <textarea id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-<?php echo esc_attr( $field_id )?>" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" cols="30" rows="10"><?php echo esc_html($item->{$field_id}); ?></textarea>
                        </label>
                    </p>

                    <?php
			        break;
                case 'text':
                default:
                ?>

                <p class="wdes-menu-element description description-wide wdes-mega-setting-field-<?php echo esc_attr( $field_info['type'] )?> wdes-mega-setting-<?php echo esc_attr( $field_id )?>" <?php echo esc_attr($data_depth) ?>>
                    <label for="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>">
				        <?php esc_html_e($field_info['label'], 'phox') ?><br>
                        <input type="text" id="edit-menu-item-<?php echo esc_attr($field_id); ?>-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-<?php echo esc_attr( $field_id )?>" name="menu-item-<?php echo esc_attr($field_id); ?>[<?php echo esc_attr($item_id) ?>]" value="<?php echo esc_html($item->{$field_id}); ?>">
                    </label>
                </p>

                <?php
                break;

            }

        }

	}


	/**
	 * Wdes Custom Save
	 *
	 * @param $menu_id
	 * @param $menu_item_db_id
	 * @param $args
	 */
	public function wdes_custom_save($menu_id, $menu_item_db_id, $args){

	    foreach ( $this->menu_item_fileds as $field_id => $field_info ){

		    if( 'checkbox' == $field_info['type'] ){

		        if( ! isset( $_POST['menu-item-'. $field_id][ $menu_item_db_id ] ) ){

			        $_POST['menu-item-'. $field_id][ $menu_item_db_id ] = '0';

                }else{

			        $_POST['menu-item-'. $field_id][ $menu_item_db_id ] = '1';

                }

		    } elseif( ! isset( $_POST['menu-item-'. $field_id][ $menu_item_db_id ] ) ){

		        $_POST['menu-item-'. $field_id][ $menu_item_db_id ] = '';

            }

		    update_post_meta( $menu_item_db_id, '_menu_item_'. $field_id, $_POST['menu-item-'. $field_id][ $menu_item_db_id ] );

        }


	}

	/**
	 * Wdes Custom Nav Edit Walker
	 *
	 * @param $walker
	 * @param $menu_id
	 * @return string
	 */
	public function wdes_custom_nav_edit_walker($walker, $menu_id)
	{
		return 'Phox\core\menu\Wdes_Menu_Edit';
	}

	/**
     * Load specific asset files on edit menu page
     */
    public function enqueue_edit_menu(){
        global $pagenow;

        if( 'nav-menus.php' == $pagenow ){

	        wp_enqueue_style( 'fontawesome5', WDES_CORE_ASSETS_URI . '/css/back/lib/fontawesome5.css', null, '1.0' );
	        wp_enqueue_style( 'iconpickercss', WDES_CORE_ASSETS_URI . '/css/back/lib/fontawesome-iconpicker.min.css', null, '1.0' );
	        wp_enqueue_style( 'wdes-editmenuscss', WDES_CORE_ASSETS_URI . '/css/back/edit-menus.css', null, '1.0' );
	        wp_enqueue_script( 'wdes-editmenusjs', WDES_CORE_ASSETS_URI . '/js/back/edit-menus.js', ['nav-menu'], '1.0' );
	        //Color picker
	        wp_enqueue_style('wp-color-picker');
	        wp_enqueue_script( 'wdes-menu-color-picker', WDES_CORE_ASSETS_URI . '/js/back/color-picker.js', array('jquery', 'jquery-ui-sortable', 'jquery-ui-draggable', 'wp-color-picker'), false, true );

        }

    }

    /**
     * Load Elementor Templates
     *
     * Get all saved template to use in the menu
     * Test with elementor 2.6.1
     *
     */
    public function get_elementor_templates(){

        if( did_action( 'elementor/loaded' ) ){

	        $args = [
		        'post_type' => 'elementor_library',
                'posts_per_page' => -1
	        ];

	        $elementor_query = new \WP_Query($args);

	        if( $elementor_query->have_posts() ){
		        foreach ($elementor_query->posts as $key => $value ){

			        $this->elementor_templates['te-'.$value->ID] = $value->post_title ;

		        }
	        }

	        wp_reset_postdata();

        }else{

	        $this->elementor_templates = [ 'no' => 'No Template' ];

        }


        $default_template = [ '' => 'Select Template' ];

	    $this->elementor_templates = array_merge($this->elementor_templates, $default_template);

    }
    /**
     * Get All Sidebar Name
     */
    public function get_sidebars_names(){

	    $sidebars_names = [];

	    $get_sidebars = get_option( 'sidebars_widgets', array() );

	    foreach (wp_get_sidebars_widgets() as $name => $value){
		    $replace_name = str_replace('-',' ',$name);
		    $sidebars_names [$name]= ucfirst($replace_name);
	    }

	    $sidebars_names ['wp_inactive_widgets'] = 'Select SideBar';

	    return $sidebars_names;

    }

}