<?php

namespace Phox\core\upgrade;

use Phox\core\upgrade\Upgrade_Abstract;

class Upgrade_Migration_250 extends Upgrade_Abstract
{

    /**
     * @inheritDoc
     */
    protected function set_version(): void
    {
        $this->version = '2.5.0';
    }

    /**
     * @inheritDoc
     */
    public function run(): void
    {
        $is_whmcs_credential_set = \wdes_opts_get('whmcs_identifier', false);

        if ($is_whmcs_credential_set) {
            set_transient('phox_whmcs_api_connected', true, DAY_IN_SECONDS);
        }

    }
}