<?php
namespace Phox\import\demo;

/**
 * Casual Demo
 * This is Twenty Nine demo for the theme
 * the primary color #3654FB
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Casual_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'casual',
            'demo_num'                 => '31',
            'import_file_name'         => 'Casual Demo',
            'import_zip_url'           => $this->build_demo_url('casual'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/casual',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/GFpOKppmnoZPurt5m7MDZ4IzcEp7weehgSVdfQW8.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Casual Kit',
            'condition_header'         => 12,
            'condition_footer'         => 362,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
