<?php
namespace Phox\import\demo;

/**
 * Host Demo
 * This is Twentieth demo for the theme
 * the primary color #49D3A3
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Host_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'host',
            'demo_num'                 => '22',
            'import_file_name'         => 'Host Demo',
            'import_zip_url'           => $this->build_demo_url('host'), // Single ZIP containing all files
            'preview_url'              => 'https://phox.whmcsdes.com/demos/host',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/FQDbLrPpM7SI05L97SfB4Te50Ut8ls90mDAShYdt.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'host kit',
            'condition_header'         => 11,
            'condition_footer'         => 234,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
