<?php
namespace Phox\import\demo;

/**
 * Monster Demo
 * This is Thirty One demo for the theme
 * the primary color #59A9FE
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://wdes.org
 */

class Monster_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'monster-pro',
            'demo_num'                 => '34',
            'import_file_name'         => 'Monster Demo',
            'import_zip_url'           => $this->build_demo_url('monster'), // Single ZIP containing all files
            'preview_url'              => 'https://phoxwp.wdes.org/monster',
            'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/juJNub7JZMbezQKcl0HF5fzPmQgEYhbCjRlTFtt2.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'Monster Kit',
            'condition_header'         => 74,
            'condition_footer'         => 534,
        ];

    }

    /**
     * Get theme options
     *
     * Returns null to use the extracted JSON file from the ZIP
     *
     * @return null
     */
    public function theme_option() {
        return null; // Will use the extracted JSON file
    }
}
