<?php
namespace Phox\import\demo;

/**
 * Primary Demo
 * This is first demo for the theme
 * the primary color #122D42
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Primary_Demo extends Demo {


	public function config() {

		return [
			'demo_id'                  => 'primary-demo',
			'demo_num'                 => '2',
			'import_file_name'         => 'Primary Demo',
			'import_zip_url'           => $this->build_demo_url('primary'), // Falls back if no license
			'preview_url'              => 'https://phox.whmcsdes.com/demos/primary',
			'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/NGWjsAsZgc0aiRw3cetEEWsHu57jsrVzZIqF9Hw8.jpg',
			'update_media_url'         => true
		];

	}

	/**
	 * Get theme options
	 *
	 * Returns null to use the extracted JSON file from the ZIP
	 *
	 * @return null
	 */
	public function theme_option() {
		return null; // Will use the extracted JSON file
	}

	/**
	 * Before Widget Import
	 * check all links in widget and replace it
	 *
	 * @since 1.5.7
	 * @param $import_files
	 * @return mixed
	 */
	public function widgets_import($import_files){
        // check if footer-widget-4 is exist
        if(!isset($import_files->{'footer-widget-4'})){
            return $import_files;
        }

        $site_url = get_site_url();
        $replace_wie_url = str_replace('https://phox.whmcsdes.com/demos/primary', $site_url, $import_files->{'footer-widget-4'}->{'widget_wdes_about-1'}->{'image'});
        $replace_wie_url = str_replace('wp-content/uploads/sites/2','wp-content/uploads', $replace_wie_url);
        $import_files->{'footer-widget-4'}->{'widget_wdes_about-1'}->{'image'} = $replace_wie_url;

        return $import_files ;
	}

}







