<?php
namespace Phox\import\demo;

/**
 * Startup Demo
 * This is fourth demo for the theme
 * the primary color #29156b
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class Startup_Demo extends Demo {


	public function config() {

		return [
			'demo_id'                  => 'startup',
			'demo_num'                 => '5',
			'import_file_name'         => 'Startup Demo',
			'import_zip_url'           => $this->build_demo_url('startup'), // Single ZIP containing all files
			'preview_url'              => 'https://phox.whmcsdes.com/demos/startup',
			'import_preview_image_url' => 'https://cdn.wdes.org/phox/demo/y5f99MAVlUnVOhTIdVe9revYrNeXOaW4fARruoIh.jpg',
			'revslider'                => [ 'showcase', 'agency', 'builders', 'email', 'youtube-hero' ],
			'update_media_url'         => true
		];

	}

	/**
	 * Get theme options
	 *
	 * Returns null to use the extracted JSON file from the ZIP
	 *
	 * @return null
	 */
	public function theme_option() {
		return null; // Will use the extracted JSON file
	}

	/**
	 * Before Widget Import
	 * check all links in widget and replace it
	 *
	 * @since 1.5.7
	 * @param $import_files
	 * @return mixed
	 */
	public function widgets_import($import_files){

        // check if footer-widget-1 is exist
        if(!isset($import_files->{'footer-widget-1'})){
            return $import_files;
        }

        $site_url = get_site_url();
        $replace_wie_url = str_replace('https://phox.whmcsdes.com/demos/startup', $site_url, $import_files->{'footer-widget-1'}->{'widget_wdes_about-1'}->{'image'});
        $replace_wie_url = str_replace('wp-content/uploads/sites/5','wp-content/uploads', $replace_wie_url);
        $import_files->{'footer-widget-1'}->{'widget_wdes_about-1'}->{'image'} = $replace_wie_url;

        return $import_files ;

	}

}







