<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'pixwell_register_options_translation' ) ) {
	function pixwell_register_options_translation() {

		return [
			'id'     => 'pixwell_ruby_config_section_translation',
			'title'  => esc_html__( 'Theme Translation', 'pixwell' ),
			'desc'   => esc_html__( 'quickly translate the site to your language.', 'pixwell' ),
			'icon'   => 'el el-filter',
			'class'  => 'section-translation',
			'fields' => [
				[
					'id'       => 'section_start_changeable_string',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Custom Strings', 'pixwell' ),
					'subtitle' => esc_html__( 'The strings below support multi-language input format.', 'pixwell' ),
					'indent'   => true,
				],
				[
					'id'          => 'meta_author_text',
					'title'       => esc_html__( 'Author Meta Label', 'pixwell' ),
					'subtitle'    => esc_html__( 'Display a label before the author entry meta.', 'pixwell' ),
					'description' => esc_html__( 'This label will be enabled when you disable the avatar image.', 'pixwell' ),
					'type'        => 'text',
					'default'     => esc_html__( 'By', 'pixwell' ),
				],
				[
					'id'          => 'readmore_text',
					'title'       => esc_html__( 'Read More Text', 'pixwell' ),
					'subtitle'    => esc_html__( 'Enter the text for the "Read More" button.', 'pixwell' ),
					'description' => esc_html__( 'Leave blank to disable this button on the blog listing.', 'pixwell' ),
					'type'        => 'text',
					'default'     => esc_html__( 'READ MORE', 'pixwell' ),
				],
				[
					'id'       => 'meta_shop_post_text',
					'title'    => esc_html__( 'Shop this Post Label', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a label for shop this post meta.', 'pixwell' ),
					'type'     => 'text',
					'default'  => esc_html__( 'Shop This Post', 'pixwell' ),
				],
				[
					'id'       => 'sponsor_label',
					'type'     => 'text',
					'title'    => esc_html__( 'Sponsor Label', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a label for the sponsor bar.', 'pixwell' ),
					'default'  => esc_html__( 'Sponsored by', 'pixwell' ),
				],
				[
					'id'       => 'single_post_left_article_header',
					'title'    => esc_html__( 'Recommended Article Header', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a heading for this section.', 'pixwell' ),
					'type'     => 'text',
					'default'  => esc_html__( 'READ NEXT', 'pixwell' ),
				],
				[
					'id'       => 'single_post_related_title',
					'type'     => 'text',
					'title'    => esc_html__( 'Related Box Header', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a heading for the related section.', 'pixwell' ),
					'default'  => esc_html__( 'You Might Also Enjoy', 'pixwell' ),
				],
				[
					'id'       => 'single_post_reaction_title',
					'type'     => 'text',
					'title'    => esc_html__( 'Reaction Header', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a heading for the reaction section.', 'pixwell' ),
					'default'  => esc_html__( 'What\'s your reaction?', 'pixwell' ),
				],
				[
					'id'       => 'slider_next',
					'title'    => esc_html__( 'Slider Next Label', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a label for the next slide.', 'pixwell' ),
					'type'     => 'text',
					'default'  => 'NEXT',
				],
				[
					'id'       => 'slider_prev',
					'title'    => esc_html__( 'Slider Previous Label', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a label for the previous slide.', 'pixwell' ),
					'type'     => 'text',
					'default'  => 'PREV',
				],
				[
					'id'     => 'section_end_changeable_string',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_quick_translation',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Quick Translation', 'pixwell' ),
					'subtitle' => esc_html__( 'Efficiently translate essential strings to your language.', 'pixwell' ),
					'indent'   => true,
				],
				[
					'id'      => 't_comment',
					'type'    => 'text',
					'title'   => '1 Comment',
					'default' => '',
				],
				[
					'id'      => 't_view',
					'type'    => 'text',
					'title'   => '1 View',
					'default' => '',
				],
				[
					'id'      => 't_add_comment',
					'type'    => 'text',
					'title'   => 'Add Comment',
					'default' => '',
				],
				[
					'id'      => 't_all',
					'type'    => 'text',
					'title'   => 'All',
					'default' => '',
				],
				[
					'id'      => 't_ago',
					'type'    => 'text',
					'title'   => '%s Ago',
					'default' => '',
				],
				[
					'id'      => 't_angry',
					'type'    => 'text',
					'title'   => 'Angry',
					'default' => '',
				],
				[
					'id'      => 't_by',
					'type'    => 'text',
					'title'   => 'by',
					'default' => '',
				],
				[
					'id'      => 't_my_bookmarks',
					'type'    => 'text',
					'title'   => 'Bookmarks',
					'default' => '',
				],
				[
					'id'      => 't_comment_closed',
					'type'    => 'text',
					'title'   => 'Comments are closed.',
					'default' => '',
				],
				[
					'id'      => 't_comments',
					'type'    => 'text',
					'title'   => '%s Comments',
					'default' => '',
				],
				[
					'id'      => 't_dead',
					'type'    => 'text',
					'title'   => 'Dead',
					'default' => '',
				],
				[
					'id'      => 't_your_email',
					'type'    => 'text',
					'title'   => 'Email',
					'default' => '',
				],
				[
					'id'      => 't_facebook',
					'type'    => 'text',
					'title'   => 'Facebook',
					'default' => '',
				],
				[
					'id'      => 't_fans',
					'type'    => 'text',
					'title'   => 'fans',
					'default' => '',
				],
				[
					'id'      => 't_followers',
					'type'    => 'text',
					'title'   => 'followers',
					'default' => '',
				],
				[
					'id'      => 't_follow',
					'type'    => 'text',
					'title'   => 'follow',
					'default' => '',
				],
				[
					'id'      => 't_happy',
					'type'    => 'text',
					'title'   => 'Happy',
					'default' => '',
				],
				[
					'id'      => 't_content_404',
					'type'    => 'text',
					'title'   => 'It looks like nothing was found at this location. Maybe try a search?',
					'default' => '',
				],
				[
					'id'      => 't_share_email_info',
					'type'    => 'text',
					'title'   => 'I found this article interesting and thought of sharing it with you. Check it out:',
					'default' => '',
				],
				[
					'id'      => 't_end_list',
					'type'    => 'text',
					'title'   => 'You’ve reached the end of the list!',
					'default' => '',
				],
				[
					'id'      => 't_like',
					'type'    => 'text',
					'title'   => 'like',
					'default' => '',
				],
				[
					'id'      => 't_instagram',
					'type'    => 'text',
					'title'   => 'Instagram',
					'default' => '',
				],
				[
					'id'      => 't_join',
					'type'    => 'text',
					'title'   => 'Join',
					'default' => '',
				],
				[
					'id'      => 't_leave_review',
					'type'    => 'text',
					'title'   => 'Leave a Review',
					'default' => '',
				],
				[
					'id'      => 't_leave_a_reply',
					'type'    => 'text',
					'title'   => 'Leave a Reply',
					'default' => '',
				],
				[
					'id'      => 't_your_comment',
					'type'    => 'text',
					'title'   => 'Leave Your Comment',
					'default' => '',
				],
				[
					'id'      => 't_leave_your_review',
					'type'    => 'text',
					'title'   => 'Leave Your Review',
					'default' => '',
				],
				[
					'id'      => 't_load_more',
					'type'    => 'text',
					'title'   => 'Load More',
					'default' => '',
				],
				[
					'id'      => 't_love',
					'type'    => 'text',
					'title'   => 'Love',
					'default' => '',
				],
				[
					'id'      => 't_your_name',
					'type'    => 'text',
					'title'   => 'Name',
					'default' => '',
				],
				[
					'id'      => 't_next',
					'type'    => 'text',
					'title'   => 'Next',
					'default' => '',
				],
				[
					'id'      => 't_next_article',
					'type'    => 'text',
					'title'   => 'Next Article',
					'default' => '',
				],
				[
					'id'      => 't_next_project',
					'type'    => 'text',
					'title'   => 'Next Project',
					'default' => '',
				],
				[
					'id'      => 't_newer_posts',
					'type'    => 'text',
					'title'   => 'Newer Posts',
					'default' => '',
				],
				[
					'id'      => 't_new_comment',
					'type'    => 'text',
					'title'   => 'Newer Comments &rarr;',
					'default' => '',
				],
				[
					'id'      => 't_new_review',
					'type'    => 'text',
					'title'   => 'Newer Reviews &rarr;',
					'default' => '',
				],
				[
					'id'      => 't_nothing_found',
					'type'    => 'text',
					'title'   => 'Nothing Found',
					'default' => '',
				],
				[
					'id'      => 't_title_404',
					'type'    => 'text',
					'title'   => 'Oops! That page can&rsquo;t be found.',
					'default' => '',
				],
				[
					'id'      => 't_older_posts',
					'type'    => 'text',
					'title'   => 'Older Posts',
					'default' => '',
				],
				[
					'id'      => 't_old_comment',
					'type'    => 'text',
					'title'   => '&larr; Older Comments',
					'default' => '',
				],
				[
					'id'      => 't_old_review',
					'type'    => 'text',
					'title'   => '&larr; Older Reviews',
					'default' => '',
				],
				[
					'id'      => 't_previous',
					'type'    => 'text',
					'title'   => 'Previous',
					'default' => '',
				],
				[
					'id'      => 't_previous_article',
					'type'    => 'text',
					'title'   => 'Previous Article',
					'default' => '',
				],
				[
					'id'      => 't_previous_project',
					'type'    => 'text',
					'title'   => 'Previous Project',
					'default' => '',
				],
				[
					'id'      => 't_page',
					'type'    => 'text',
					'title'   => 'Page',
					'default' => '',
				],
				[
					'id'      => 't_pages',
					'type'    => 'text',
					'title'   => 'Pages:',
					'default' => '',
				],
				[
					'id'      => 't_bookmark_empty',
					'type'    => 'text',
					'title'   => 'Please add some posts to see your added bookmarks.',
					'default' => '',
				],
				[
					'id'      => 't_bookmark_empty',
					'type'    => 'text',
					'title'   => 'Please add some posts to see your added bookmarks.',
					'default' => '',
				],
				[
					'id'      => 't_pinterest',
					'type'    => 'text',
					'title'   => 'Pinterest',
					'default' => '',
				],
				[
					'id'      => 't_post_review',
					'type'    => 'text',
					'title'   => 'Post Review',
					'default' => '',
				],
				[
					'id'      => 't_select_rating',
					'type'    => 'text',
					'title'   => 'Please select a rating',
					'default' => '',
				],
				[
					'id'      => 't_pin',
					'type'    => 'text',
					'title'   => 'pin',
					'default' => '',
				],
				[
					'id'      => 't_updated',
					'type'    => 'text',
					'title'   => 'Last Updated',
					'default' => '',
				],
				[
					'id'      => 't_review',
					'type'    => 'text',
					'title'   => '1 Review',
					'default' => '',
				],
				[
					'id'      => 't_reviews',
					'type'    => 'text',
					'title'   => '%s Reviews',
					'default' => '',
				],
				[
					'id'      => 't_read',
					'type'    => 'text',
					'title'   => '%s Min Read',
					'default' => '',
				],
				[
					'id'      => 't_review_overview',
					'type'    => 'text',
					'title'   => 'Review Overview',
					'default' => '',
				],
				[
					'id'      => 't_return_home',
					'type'    => 'text',
					'title'   => 'Return to Home',
					'default' => '',
				],
				[
					'id'      => 't_read_later',
					'type'    => 'text',
					'title'   => 'Read it Later',
					'default' => '',
				],
				[
					'id'      => 't_remove_bookmark',
					'type'    => 'text',
					'title'   => 'Remove All List',
					'default' => '',
				],
				[
					'id'      => 't_search',
					'type'    => 'text',
					'title'   => 'Search',
					'default' => '',
				],
				[
					'id'      => 't_search_result',
					'type'    => 'text',
					'title'   => 'Search Results for: %s',
					'default' => '',
				],
				[
					'id'      => 't_share',
					'type'    => 'text',
					'title'   => 'Share',
					'default' => '',
				],
				[
					'id'      => 't_share_on',
					'type'    => 'text',
					'title'   => 'Share on',
					'default' => '',
				],
				[
					'id'      => 't_shares',
					'type'    => 'text',
					'title'   => 'Shares',
					'default' => '',
				],
				[
					'id'      => 't_source',
					'type'    => 'text',
					'title'   => 'Source:',
					'default' => '',
				],
				[
					'id'      => 't_summary',
					'type'    => 'text',
					'title'   => 'Summary',
					'default' => '',
				],
				[
					'id'      => 't_share_facebook',
					'type'    => 'text',
					'title'   => 'Share on Facebook',
					'default' => '',
				],
				[
					'id'      => 't_share_twitter',
					'type'    => 'text',
					'title'   => 'Share on Twitter',
					'default' => '',
				],
				[
					'id'      => 't_share_pinterest',
					'type'    => 'text',
					'title'   => 'Share on Pinterest',
					'default' => '',
				],
				[
					'id'      => 't_share_whatsapp',
					'type'    => 'text',
					'title'   => 'Share on WhatsApp',
					'default' => '',
				],
				[
					'id'      => 't_share_linkedin',
					'type'    => 'text',
					'title'   => 'Share on Linkedin',
					'default' => '',
				],
				[
					'id'      => 't_share_tumblr',
					'type'    => 'text',
					'title'   => 'Share on Tumblr',
					'default' => '',
				],
				[
					'id'      => 't_share_reddit',
					'type'    => 'text',
					'title'   => 'Share on Reddit',
					'default' => '',
				],
				[
					'id'      => 't_share_vk',
					'type'    => 'text',
					'title'   => 'Share on VKontakte',
					'default' => '',
				],
				[
					'id'      => 't_share_telegram',
					'type'    => 'text',
					'title'   => 'Share on Telegram',
					'default' => '',
				],
				[
					'id'      => 't_share_email',
					'type'    => 'text',
					'title'   => 'Share on Email',
					'default' => '',
				],
				[
					'id'      => 't_no_search_result',
					'type'    => 'text',
					'title'   => 'Sorry, but nothing matched your search terms. Please try again with some different keywords.',
					'default' => '',
				],
				[
					'id'      => 't_sorry',
					'type'    => 'text',
					'title'   => 'Sorry!',
					'default' => '',
				],
				[
					'id'      => 't_sad',
					'type'    => 'text',
					'title'   => 'Sad',
					'default' => '',
				],
				[
					'id'      => 't_sleepy',
					'type'    => 'text',
					'title'   => 'Sleepy',
					'default' => '',
				],
				[
					'id'      => 't_cons',
					'type'    => 'text',
					'title'   => 'The Cons',
					'default' => '',
				],
				[
					'id'      => 't_pros',
					'type'    => 'text',
					'title'   => 'The Pros',
					'default' => '',
				],
				[
					'id'      => 't_twitter',
					'type'    => 'text',
					'title'   => 'Twitter',
					'default' => '',
				],
				[
					'id'      => 't_tags',
					'type'    => 'text',
					'title'   => 'Tags',
					'default' => '',
				],
				[
					'id'      => 't_telegram',
					'type'    => 'text',
					'title'   => 'Telegram',
					'default' => '',
				],
				[
					'id'      => 't_user_rating',
					'type'    => 'text',
					'title'   => 'User Rating',
					'default' => '',
				],
				[
					'id'      => 't_views',
					'type'    => 'text',
					'title'   => '%s Views',
					'default' => '',
				],
				[
					'id'      => 't_votes',
					'type'    => 'text',
					'title'   => 'Votes',
					'default' => '',
				],
				[
					'id'      => 't_view_comment',
					'type'    => 'text',
					'title'   => 'View Comments',
					'default' => '',
				],
				[
					'id'      => 't_via',
					'type'    => 'text',
					'title'   => 'Via:',
					'default' => '',
				],
				[
					'id'      => 't_all_posts_by',
					'type'    => 'text',
					'title'   => 'View More Posts',
					'default' => '',
				],
				[
					'id'      => 't_view_cart',
					'type'    => 'text',
					'title'   => 'View Cart',
					'default' => '',
				],
				[
					'id'      => 't_view_gallery',
					'type'    => 'text',
					'title'   => 'View Gallery',
					'default' => '',
				],
				[
					'id'      => 't_view_gallery',
					'type'    => 'text',
					'title'   => 'View Gallery',
					'default' => '',
				],
				[
					'id'      => 't_view_all_results',
					'type'    => 'text',
					'title'   => 'VIEW ALL RESULTS',
					'default' => '',
				],
				[
					'id'      => 't_view_bookmark',
					'type'    => 'text',
					'title'   => 'View All Your Bookmarks',
					'default' => '',
				],
				[
					'id'      => 't_your_review',
					'type'    => 'text',
					'title'   => 'Your review',
					'default' => '',
				],
				[
					'id'      => 't_your_rating',
					'type'    => 'text',
					'title'   => 'Your rating',
					'default' => '',
				],
				[
					'id'      => 't_your_website',
					'type'    => 'text',
					'title'   => 'Website',
					'default' => '',
				],
				[
					'id'      => 't_wink',
					'type'    => 'text',
					'title'   => 'Wink',
					'default' => '',
				],
				[
					'id'      => 't_no_trend',
					'type'    => 'text',
					'title'   => 'Will be updated soon!',
					'default' => '',
				],
				[
					'id'     => 'section_end_quick_translation',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

