<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'pixwell_register_options_typo' ) ) {
	function pixwell_register_options_typo() {

		return [
			'id'    => 'pixwell_config_section_typo',
			'title' => esc_html__( 'Typography', 'pixwell' ),
			'icon'  => 'el el-fontsize',
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_body' ) ) {
	function pixwell_register_options_typo_body() {

		return [
			'id'         => 'pixwell_config_section_typo_body',
			'title'      => esc_html__( 'Site Body', 'pixwell' ),
			'desc'       => esc_html__( 'Customize font values for the site body. These settings will affect the text on pages and post content.', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'fields'     => [
				[
					'id'     => 'section_start_font_body',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Site Body', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_body',
					'type'           => 'typography',
					'title'          => esc_html__( 'Body Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'These options will apply to almost every post and page content on your site.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Poppins | font-size: 16px | font-weight: 400 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'all_styles'     => true,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'            => 'font_size_mobile',
					'type'          => 'slider',
					'title'         => esc_html__( 'Reduce Font Size on Mobile', 'pixwell' ),
					'subtitle'      => esc_html__( 'Select a percent font size value (%) for page/post content on mobile devices.', 'pixwell' ),
					'default'       => 90,
					'min'           => 1,
					'step'          => 1,
					'max'           => 100,
					'display_value' => 'label',
				],
				[
					'id'     => 'section_end_font_body',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Post Summary/Excerpt', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_excerpt',
					'type'           => 'typography',
					'title'          => esc_html__( 'Post Summary/Excerpt Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select fonts for the post excerpt or other description elements.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Poppins | font-size: 13px | font-weight: 400 | color: #666 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
				],
				[
					'id'       => 'font_excerpt_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'Excerpt - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for mobile devices, screen width < 768px.', 'pixwell' ),
					'default'  => '',
				],
				[
					'id'     => 'section_end_font_excerpt',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_quote',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'BlockQuotes', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_quote',
					'type'           => 'typography',
					'title'          => esc_html__( 'BlockQuotes Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Customize the font for BlockQuotes on your site.', 'pixwell' ),
					'desc'           => esc_html__( 'By default, BlockQuotes use the font settings based on H1.', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'font-size'      => false,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
				],
				[
					'id'     => 'section_end_font_quote',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_title' ) ) {
	/**
	 * @return array
	 */
	function pixwell_register_options_typo_title() {

		return [
			'id'         => 'pixwell_config_section_typo_title',
			'title'      => esc_html__( 'Post Title - H Tags', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'Select a font value for header tags (H1 to H6). These options also apply to post titles.', 'pixwell' ),
			'fields'     => [
				[
					'id'    => 'info_font_size',
					'type'  => 'info',
					'style' => 'warning',
					'desc'  => esc_html__( 'If you customize font sizes for header tags (H1 to H6), make sure to adjust mobile and tablet font size settings accordingly.', 'pixwell' ),
				],
				[
					'id'    => 'info_font_size_input',
					'type'  => 'info',
					'style' => 'info',
					'desc'  => esc_html__( 'The font size input format is numeric. For example: 30', 'pixwell' ),
				],
				[
					'id'     => 'section_start_font_h1',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'H1 Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_h1',
					'type'           => 'typography',
					'title'          => esc_html__( 'H1 Font', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-weight: 700 | color: #333 ]', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the H1 tag and [ CSS classname: .h1 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_h1_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H1 - Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a custom font size (in px) for the desktop devices.', 'pixwell' ),
					'desc'     => esc_html__( 'The default value is 40', 'pixwell' ),
				],
				[
					'id'       => 'font_h1_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H1 - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h1_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H1 - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h1_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H1 - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_h1',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_h2',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'H2 Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_h2',
					'type'           => 'typography',
					'title'          => esc_html__( 'H2 Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the H2 tag and [ CSS classname: .h2 ]', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-weight: 700 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_h2_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H2 - Font Size', 'pixwell' ),
					'desc'     => esc_html__( 'The default value is 26px.', 'pixwell' ),
					'subtitle' => esc_html__( 'Select font size value (px) for this heading tag on desktop devices.', 'pixwell' ),
				],
				[
					'id'       => 'font_h2_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H2 - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h2_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H2 - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h2_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H2 - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_h2',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_h3',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'H3 Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_h3',
					'type'           => 'typography',
					'title'          => esc_html__( 'H3 Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the H3 tag and [ CSS classname: .h3 ]', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-weight: 700 | color: #333 ]. ', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_h3_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H3 - Font Size', 'pixwell' ),
					'desc'     => esc_html__( 'The default value is 20.', 'pixwell' ),
					'subtitle' => esc_html__( 'Select font size value (px) for this heading tag on desktop devices.', 'pixwell' ),
				],
				[
					'id'       => 'font_h3_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H3 - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h3_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H3 - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h3_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H3 - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_h3',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_h4',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'H4 Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_h4',
					'type'           => 'typography',
					'title'          => esc_html__( 'H4 Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the H4 tag and [ CSS classname: .h4 ]', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-weight: 700 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_h4_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H4 - Font Size', 'pixwell' ),
					'desc'     => esc_html__( 'The default value is 16.', 'pixwell' ),
					'subtitle' => esc_html__( 'Select font size value (px) for this heading tag on desktop devices.', 'pixwell' ),
				],
				[
					'id'       => 'font_h4_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H4 - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h4_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H4 - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h4_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H4 - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_h4',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_h5',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'H5 Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_h5',
					'type'           => 'typography',
					'title'          => esc_html__( 'H5 Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the H5 tag and [ CSS classname: .h5 ]', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-weight: 700 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_h5_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H5 - Font Size', 'pixwell' ),
					'desc'     => esc_html__( 'The default value is 15.', 'pixwell' ),
					'subtitle' => esc_html__( 'Select font size value (px) for this heading tag on desktop devices.', 'pixwell' ),
				],
				[
					'id'       => 'font_h5_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H5 - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h5_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H5 - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h5_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H5 - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_h5',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_h6',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'H6 Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_h6',
					'type'           => 'typography',
					'title'          => esc_html__( 'Font H6', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the H6 tag and [ CSS classname: .h6 ]', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-weight: 700 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_h6_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H6 - Font Size', 'pixwell' ),
					'desc'     => esc_html__( 'The default value is 14.', 'pixwell' ),
					'subtitle' => esc_html__( 'Select font size value (px) for this heading tag on desktop devices.', 'pixwell' ),
				],
				[
					'id'       => 'font_h6_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H6 - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h6_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H6 - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_h6_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'H6 - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_h6',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_title_transform',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Post Title - Text Transform Uppercase', 'pixwell' ),
					'subtitle' => esc_html__( 'Uppercase style for the post title.', 'pixwell' ),
					'indent'   => true,
				],
				[
					'id'          => 'title_uppercase',
					'type'        => 'switch',
					'title'       => esc_html__( 'Post Title - Uppercase Style', 'pixwell' ),
					'subtitle'    => esc_html__( 'Enable text-transform uppercase for the post title.', 'pixwell' ),
					'description' => esc_html__( 'This setting will only apply to the post title.', 'pixwell' ),
					'default'     => false,
				],
				[
					'id'     => 'section_end_title_transform',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_font_tagline',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Single Tagline Font', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_tagline',
					'type'           => 'typography',
					'title'          => esc_html__( 'Font Single Tagline', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the single tagline, display below the single title.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ use H4 font settings ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'font-weight'    => true,
					'font-size'      => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_tagline_size',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'Tagline Font - Font Size', 'pixwell' ),
					'desc'     => esc_html__( 'Default [ use H4 font settings ]', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the desktop devices.', 'pixwell' ),
				],
				[
					'id'       => 'font_tagline_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'Tagline Font - Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'       => 'font_tagline_size_tablet',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'Tagline Font - Tablet Font Size (Vertical)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the tablet devices, screen width < 992px.', 'pixwell' ),
				],
				[
					'id'       => 'font_tagline_size_tablet_hoz',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'Tagline Font - Tablet Font Size (Horizontal)', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the horizontal tablet devices, screen width < 1024px.', 'pixwell' ),
				],
				[
					'id'     => 'section_end_font_tagline',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_meta' ) ) {
	/**
	 * @return array
	 */
	function pixwell_register_options_typo_meta() {

		return [
			'id'         => 'pixwell_config_section_typo_meta',
			'title'      => esc_html__( 'Entry Meta', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'Customize font for the post entry meta.', 'pixwell' ),
			'fields'     => [
				[
					'id'     => 'section_start_section_font_category',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Category', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_cat_icon',
					'type'           => 'typography',
					'title'          => esc_html__( 'Entry Category Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the category icon.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Montserrat | font-size: 11px | font-weight: 700 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'font-weight'    => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'     => 'section_end_section_font_category',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_section_font_meta',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Entry Meta', 'pixwell' ),
					'indent' => true,
				],
				[
					'id'             => 'font_post_meta',
					'type'           => 'typography',
					'title'          => esc_html__( 'Entry Meta Info Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for entry meta info: date, view, comment', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Montserrat | font-size: 11px | font-weight: 500 | color: #777 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'font-weight'    => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'             => 'font_post_meta_author',
					'type'           => 'typography',
					'title'          => esc_html__( 'Important Meta Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the highlight meta such as: author, sponsored meta.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Montserrat | font-size: 11px | font-weight: 600 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'font-weight'    => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'     => 'section_end_section_font_meta',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_section_font_btn',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Miscellaneous', 'pixwell' ),
					'subtitle' => esc_html__( 'The Breadcrumb Font settings will also apply to small other elements such as caption, pagination and more.', 'pixwell' ),
					'indent'   => true,
				],
				[
					'id'             => 'font_button',
					'type'           => 'typography',
					'title'          => esc_html__( 'Button Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the "Read More" button and other buttons in your site.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Montserrat | font-size: 11px | font-weight: 600 | color: #333 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'font-weight'    => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'             => 'font_input',
					'type'           => 'typography',
					'title'          => esc_html__( 'Input/Label Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the input label.', 'pixwell' ),
					'desc'           => esc_html__( 'Default  [ font-family: Montserrat | font-size: 14px | font-weight: 400 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'font-weight'    => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'             => 'font_breadcrumb',
					'type'           => 'typography',
					'title'          => esc_html__( 'Breadcrumb Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the breadcrumb bar.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Montserrat | font-size: 12px | font-weight: 600 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'font-weight'    => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'     => 'section_end_section_font_btn',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_heading' ) ) {
	/**
	 * @return array
	 */
	function pixwell_register_options_typo_heading() {

		return [
			'id'         => 'pixwell_config_section_typo_heading',
			'title'      => esc_html__( 'Block/Widget Header', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'Customize font for the block and widget header.', 'pixwell' ),
			'fields'     => [
				[
					'id'       => 'section_start_font_heading_block',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'for Full Width and Content Area', 'pixwell' ),
					'subtitle' => esc_html__( 'These settings below will apply to the block header which are located in the full width and content sections.', 'pixwell' ),
					'indent'   => true,
				],
				[
					'id'             => 'font_header_block',
					'type'           => 'typography',
					'title'          => esc_html__( 'Header Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the header of content and fullwidth blocks.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-size: 20px | font-weight: 700 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'all_styles'     => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'       => 'font_header_block_size_mobile',
					'type'     => 'text',
					'validate' => 'numeric',
					'class'    => 'small-text',
					'title'    => esc_html__( 'Mobile Font Size', 'pixwell' ),
					'subtitle' => esc_html__( 'Input a font size value (px) for the mobile devices, screen width < 768px.', 'pixwell' ),
				],
				[
					'id'             => 'font_header_filter',
					'type'           => 'typography',
					'title'          => esc_html__( 'Quick Filter Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the ajax quick filter in the block header.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Montserrat | font-size: 11px | font-weight: 600 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'all_styles'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'     => 'section_end_font_heading_block',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_font_heading_widget',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'for Sidebar Area', 'pixwell' ),
					'subtitle' => esc_html__( 'These settings below will apply to the block header which are located in the sidebar and footer sections.', 'pixwell' ),
					'indent'   => true,
				],
				[
					'id'             => 'font_header_widget',
					'type'           => 'typography',
					'title'          => esc_html__( 'Widget Header Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the sidebar widget header. These options will apply to sidebar widgets and other sections.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-size: 18px | font-weight: 700 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'all_styles'     => false,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'             => 'font_widget_menu',
					'type'           => 'typography',
					'title'          => esc_html__( 'Widget Menu Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the menu widget.', 'pixwell' ),
					'desc'           => esc_html__( 'Default font values based on the post title font settings.', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'all_styles'     => false,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'     => 'section_end_font_heading_widget',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_navigation' ) ) {
	/**
	 * @return array
	 */
	function pixwell_register_options_typo_navigation() {

		return [
			'id'         => 'pixwell_config_section_typo_navigation',
			'title'      => esc_html__( 'Main Navigation', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'Customize font for your the main menu.', 'pixwell' ),
			'fields'     => [
				[
					'id'             => 'font_navbar',
					'type'           => 'typography',
					'title'          => esc_html__( 'Menu Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the main menu.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-size: 16px | font-weight: 600 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'all_styles'     => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'             => 'font_navbar_sub',
					'type'           => 'typography',
					'title'          => esc_html__( 'Sub-level Menus', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for sub-level menu items.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-size: 14px | font-weight: 500  ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'all_styles'     => false,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_logo' ) ) {
	function pixwell_register_options_typo_logo() {

		return [
			'id'         => 'pixwell_config_section_typo_logo',
			'title'      => esc_html__( 'Text Logo', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'The settings will apply to the text logo.', 'pixwell' ),
			'fields'     => [
				[
					'id'             => 'font_logo_text',
					'type'           => 'typography',
					'title'          => esc_html__( 'Text Logo', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the header text logo if you would like to use logo text.', 'pixwell' ),
					'desc'           => esc_html__( 'Default: Montserrat [ font-size: 32px | font-weight: 900 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'all_styles'     => false,
					'units'          => 'px',
					'default'        => [],
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_topbar' ) ) {
	function pixwell_register_options_typo_topbar() {

		return [
			'id'         => 'pixwell_config_section_typo_topbar',
			'title'      => esc_html__( 'Top Bar', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'The settings will apply to the top bar of your website.', 'pixwell' ),
			'fields'     => [
				[
					'id'             => 'font_topbar',
					'type'           => 'typography',
					'title'          => esc_html__( 'Text Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for text in the top bar.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-size: 13px | font-weight: 400 | color: #fff ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => true,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'all_styles'     => true,
					'units'          => 'px',
					'default'        => [],
				],
				[
					'id'             => 'font_topbar_menu',
					'type'           => 'typography',
					'title'          => esc_html__( 'Menu Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'Select font values for the top bar menu.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-size: 13px | font-weight: 500 | color: #fff ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'all_styles'     => true,
					'units'          => 'px',
					'default'        => [],
				],
			],
		];
	}
}

if ( ! function_exists( 'pixwell_register_options_typo_fmenu' ) ) {
	function pixwell_register_options_typo_fmenu() {

		return [
			'id'         => 'pixwell_config_section_typo_fmenu',
			'title'      => esc_html__( 'Footer Menu', 'pixwell' ),
			'icon'       => 'el el-font',
			'subsection' => true,
			'desc'       => esc_html__( 'The settings will apply to the footer menu.', 'pixwell' ),
			'fields'     => [
				[
					'id'             => 'footer_menu_font',
					'type'           => 'typography',
					'title'          => esc_html__( 'Footer Menu Font', 'pixwell' ),
					'subtitle'       => esc_html__( 'select font values for the footer menu.', 'pixwell' ),
					'desc'           => esc_html__( 'Default [ font-family: Quicksand | font-size: 16px | font-weight: 700 ]', 'pixwell' ),
					'google'         => true,
					'font-backup'    => true,
					'text-align'     => false,
					'color'          => false,
					'all_styles'     => false,
					'text-transform' => true,
					'letter-spacing' => true,
					'line-height'    => false,
					'units'          => 'px',
					'default'        => [],
				],
			],
		];
	}
}