<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

							do_action( 'progress_action_page_content_end_text' );
							
							// Widgets area below the content
							progress_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'progress_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'progress_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'progress_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'progress_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$progress_body_style = progress_get_theme_option( 'body_style' );
					$progress_widgets_name = progress_get_theme_option( 'widgets_below_page', 'hide' );
					$progress_show_widgets = ! progress_is_off( $progress_widgets_name ) && is_active_sidebar( $progress_widgets_name );
					$progress_show_related = progress_is_single() && progress_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $progress_show_widgets || $progress_show_related ) {
						if ( 'fullscreen' != $progress_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $progress_show_related ) {
							do_action( 'progress_action_related_posts' );
						}

						// Widgets area below page content
						if ( $progress_show_widgets ) {
							progress_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $progress_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'progress_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'progress_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! progress_is_singular( 'post' ) && ! progress_is_singular( 'attachment' ) ) || ! in_array ( progress_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="progress_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'progress_action_before_footer' );

				// Footer
				$progress_footer_type = progress_get_theme_option( 'footer_type' );
				if ( 'custom' == $progress_footer_type && ! progress_is_layouts_available() ) {
					$progress_footer_type = 'default';
				}
				get_template_part( apply_filters( 'progress_filter_get_template_part', "templates/footer-" . sanitize_file_name( $progress_footer_type ) ) );

				do_action( 'progress_action_after_footer' );

			}
			?>

			<?php do_action( 'progress_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'progress_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'progress_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>