<?php
/**
 * The Front Page template file.
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.31
 */

get_header();

// If front-page is a static page
if ( get_option( 'show_on_front' ) == 'page' ) {

	// If Front Page Builder is enabled - display sections
	if ( progress_is_on( progress_get_theme_option( 'front_page_enabled', false ) ) ) {

		if ( have_posts() ) {
			the_post();
		}

		$progress_sections = progress_array_get_keys_by_value( progress_get_theme_option( 'front_page_sections' ) );
		if ( is_array( $progress_sections ) ) {
			foreach ( $progress_sections as $progress_section ) {
				get_template_part( apply_filters( 'progress_filter_get_template_part', 'front-page/section', $progress_section ), $progress_section );
			}
		}

		// Else if this page is a blog archive
	} elseif ( is_page_template( 'blog.php' ) ) {
		get_template_part( apply_filters( 'progress_filter_get_template_part', 'blog' ) );

		// Else - display a native page content
	} else {
		get_template_part( apply_filters( 'progress_filter_get_template_part', 'page' ) );
	}

	// Else get the template 'index.php' to show posts
} else {
	get_template_part( apply_filters( 'progress_filter_get_template_part', 'index' ) );
}

get_footer();
